// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Class representing Diagnostic Metric.
 */
@Fluent
public final class DiagnosticMetricSample {
    /*
     * Time at which metric is measured
     */
    @JsonProperty(value = "timestamp")
    private OffsetDateTime timestamp;

    /*
     * Role Instance. Null if this counter is not per instance
     * This is returned and should be whichever instance name we desire to be returned
     * i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     * where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis
     */
    @JsonProperty(value = "roleInstance")
    private String roleInstance;

    /*
     * Total value of the metric. If multiple measurements are made this will have sum of all.
     */
    @JsonProperty(value = "total")
    private Double total;

    /*
     * Maximum of the metric sampled during the time period
     */
    @JsonProperty(value = "maximum")
    private Double maximum;

    /*
     * Minimum of the metric sampled during the time period
     */
    @JsonProperty(value = "minimum")
    private Double minimum;

    /*
     * Whether the values are aggregates across all workers or not
     */
    @JsonProperty(value = "isAggregated")
    private Boolean isAggregated;

    /**
     * Creates an instance of DiagnosticMetricSample class.
     */
    public DiagnosticMetricSample() {
    }

    /**
     * Get the timestamp property: Time at which metric is measured.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: Time at which metric is measured.
     * 
     * @param timestamp the timestamp value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the roleInstance property: Role Instance. Null if this counter is not per instance
     * This is returned and should be whichever instance name we desire to be returned
     * i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     * where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
     * 
     * @return the roleInstance value.
     */
    public String roleInstance() {
        return this.roleInstance;
    }

    /**
     * Set the roleInstance property: Role Instance. Null if this counter is not per instance
     * This is returned and should be whichever instance name we desire to be returned
     * i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     * where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
     * 
     * @param roleInstance the roleInstance value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withRoleInstance(String roleInstance) {
        this.roleInstance = roleInstance;
        return this;
    }

    /**
     * Get the total property: Total value of the metric. If multiple measurements are made this will have sum of all.
     * 
     * @return the total value.
     */
    public Double total() {
        return this.total;
    }

    /**
     * Set the total property: Total value of the metric. If multiple measurements are made this will have sum of all.
     * 
     * @param total the total value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withTotal(Double total) {
        this.total = total;
        return this;
    }

    /**
     * Get the maximum property: Maximum of the metric sampled during the time period.
     * 
     * @return the maximum value.
     */
    public Double maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: Maximum of the metric sampled during the time period.
     * 
     * @param maximum the maximum value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the minimum property: Minimum of the metric sampled during the time period.
     * 
     * @return the minimum value.
     */
    public Double minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: Minimum of the metric sampled during the time period.
     * 
     * @param minimum the minimum value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the isAggregated property: Whether the values are aggregates across all workers or not.
     * 
     * @return the isAggregated value.
     */
    public Boolean isAggregated() {
        return this.isAggregated;
    }

    /**
     * Set the isAggregated property: Whether the values are aggregates across all workers or not.
     * 
     * @param isAggregated the isAggregated value to set.
     * @return the DiagnosticMetricSample object itself.
     */
    public DiagnosticMetricSample withIsAggregated(Boolean isAggregated) {
        this.isAggregated = isAggregated;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
