// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Function app resource requirements.
 */
@Fluent
public final class ResourceConfig {
    /*
     * Required CPU in cores, e.g. 0.5
     */
    @JsonProperty(value = "cpu")
    private Double cpu;

    /*
     * Required memory, e.g. "1Gi"
     */
    @JsonProperty(value = "memory")
    private String memory;

    /**
     * Creates an instance of ResourceConfig class.
     */
    public ResourceConfig() {
    }

    /**
     * Get the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @return the cpu value.
     */
    public Double cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @param cpu the cpu value to set.
     * @return the ResourceConfig object itself.
     */
    public ResourceConfig withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Get the memory property: Required memory, e.g. "1Gi".
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Set the memory property: Required memory, e.g. "1Gi".
     * 
     * @param memory the memory value to set.
     * @return the ResourceConfig object itself.
     */
    public ResourceConfig withMemory(String memory) {
        this.memory = memory;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
