// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A database connection configuration file.
 */
@Immutable
public final class StaticSiteDatabaseConnectionConfigurationFileOverview {
    /*
     * The name of the configuration file.
     */
    @JsonProperty(value = "fileName", access = JsonProperty.Access.WRITE_ONLY)
    private String fileName;

    /*
     * The Base64 encoding of the file contents.
     */
    @JsonProperty(value = "contents", access = JsonProperty.Access.WRITE_ONLY)
    private String contents;

    /*
     * The type of configuration file.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Creates an instance of StaticSiteDatabaseConnectionConfigurationFileOverview class.
     */
    public StaticSiteDatabaseConnectionConfigurationFileOverview() {
    }

    /**
     * Get the fileName property: The name of the configuration file.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Get the contents property: The Base64 encoding of the file contents.
     * 
     * @return the contents value.
     */
    public String contents() {
        return this.contents;
    }

    /**
     * Get the type property: The type of configuration file.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
