// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The error info.
 */
@Fluent
public class ErrorInfo {
    /*
     * The error code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /**
     * Creates an instance of ErrorInfo class.
     */
    public ErrorInfo() {
    }

    /**
     * Get the code property: The error code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: The error code.
     * 
     * @param code the code value to set.
     * @return the ErrorInfo object itself.
     */
    public ErrorInfo withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (code() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property code in model ErrorInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ErrorInfo.class);
}
