// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Routing rules in production experiments.
 */
@Fluent
public final class Experiments {
    /*
     * List of ramp-up rules.
     */
    @JsonProperty(value = "rampUpRules")
    private List<RampUpRule> rampUpRules;

    /**
     * Creates an instance of Experiments class.
     */
    public Experiments() {
    }

    /**
     * Get the rampUpRules property: List of ramp-up rules.
     * 
     * @return the rampUpRules value.
     */
    public List<RampUpRule> rampUpRules() {
        return this.rampUpRules;
    }

    /**
     * Set the rampUpRules property: List of ramp-up rules.
     * 
     * @param rampUpRules the rampUpRules value to set.
     * @return the Experiments object itself.
     */
    public Experiments withRampUpRules(List<RampUpRule> rampUpRules) {
        this.rampUpRules = rampUpRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rampUpRules() != null) {
            rampUpRules().forEach(e -> e.validate());
        }
    }
}
