// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Open authentication access policy defined by user.
 */
@Fluent
public final class OpenAuthenticationAccessPolicy {
    /*
     * Type of provider for OAuth.
     */
    @JsonProperty(value = "type")
    private OpenAuthenticationProviderType type;

    /*
     * The access policy claims.
     */
    @JsonProperty(value = "claims")
    private List<OpenAuthenticationPolicyClaim> claims;

    /**
     * Creates an instance of OpenAuthenticationAccessPolicy class.
     */
    public OpenAuthenticationAccessPolicy() {
    }

    /**
     * Get the type property: Type of provider for OAuth.
     * 
     * @return the type value.
     */
    public OpenAuthenticationProviderType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of provider for OAuth.
     * 
     * @param type the type value to set.
     * @return the OpenAuthenticationAccessPolicy object itself.
     */
    public OpenAuthenticationAccessPolicy withType(OpenAuthenticationProviderType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the claims property: The access policy claims.
     * 
     * @return the claims value.
     */
    public List<OpenAuthenticationPolicyClaim> claims() {
        return this.claims;
    }

    /**
     * Set the claims property: The access policy claims.
     * 
     * @param claims the claims value to set.
     * @return the OpenAuthenticationAccessPolicy object itself.
     */
    public OpenAuthenticationAccessPolicy withClaims(List<OpenAuthenticationPolicyClaim> claims) {
        this.claims = claims;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (claims() != null) {
            claims().forEach(e -> e.validate());
        }
    }
}
