// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * BackupItem resource specific properties.
 */
@Immutable
public final class BackupItemProperties {
    /*
     * Id of the backup.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private Integer backupId;

    /*
     * SAS URL for the storage account container which contains this backup.
     */
    @JsonProperty(value = "storageAccountUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String storageAccountUrl;

    /*
     * Name of the blob which contains data for this backup.
     */
    @JsonProperty(value = "blobName", access = JsonProperty.Access.WRITE_ONLY)
    private String blobName;

    /*
     * Name of this backup.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Backup status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private BackupItemStatus status;

    /*
     * Size of the backup in bytes.
     */
    @JsonProperty(value = "sizeInBytes", access = JsonProperty.Access.WRITE_ONLY)
    private Long sizeInBytes;

    /*
     * Timestamp of the backup creation.
     */
    @JsonProperty(value = "created", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime created;

    /*
     * Details regarding this backup. Might contain an error message.
     */
    @JsonProperty(value = "log", access = JsonProperty.Access.WRITE_ONLY)
    private String log;

    /*
     * List of databases included in the backup.
     */
    @JsonProperty(value = "databases", access = JsonProperty.Access.WRITE_ONLY)
    private List<DatabaseBackupSetting> databases;

    /*
     * True if this backup has been created due to a schedule being triggered.
     */
    @JsonProperty(value = "scheduled", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean scheduled;

    /*
     * Timestamp of a last restore operation which used this backup.
     */
    @JsonProperty(value = "lastRestoreTimeStamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRestoreTimestamp;

    /*
     * Timestamp when this backup finished.
     */
    @JsonProperty(value = "finishedTimeStamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime finishedTimestamp;

    /*
     * Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
     */
    @JsonProperty(value = "correlationId", access = JsonProperty.Access.WRITE_ONLY)
    private String correlationId;

    /*
     * Size of the original web app which has been backed up.
     */
    @JsonProperty(value = "websiteSizeInBytes", access = JsonProperty.Access.WRITE_ONLY)
    private Long websiteSizeInBytes;

    /**
     * Creates an instance of BackupItemProperties class.
     */
    public BackupItemProperties() {
    }

    /**
     * Get the backupId property: Id of the backup.
     * 
     * @return the backupId value.
     */
    public Integer backupId() {
        return this.backupId;
    }

    /**
     * Get the storageAccountUrl property: SAS URL for the storage account container which contains this backup.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    /**
     * Get the blobName property: Name of the blob which contains data for this backup.
     * 
     * @return the blobName value.
     */
    public String blobName() {
        return this.blobName;
    }

    /**
     * Get the name property: Name of this backup.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: Backup status.
     * 
     * @return the status value.
     */
    public BackupItemStatus status() {
        return this.status;
    }

    /**
     * Get the sizeInBytes property: Size of the backup in bytes.
     * 
     * @return the sizeInBytes value.
     */
    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    /**
     * Get the created property: Timestamp of the backup creation.
     * 
     * @return the created value.
     */
    public OffsetDateTime created() {
        return this.created;
    }

    /**
     * Get the log property: Details regarding this backup. Might contain an error message.
     * 
     * @return the log value.
     */
    public String log() {
        return this.log;
    }

    /**
     * Get the databases property: List of databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    /**
     * Get the scheduled property: True if this backup has been created due to a schedule being triggered.
     * 
     * @return the scheduled value.
     */
    public Boolean scheduled() {
        return this.scheduled;
    }

    /**
     * Get the lastRestoreTimestamp property: Timestamp of a last restore operation which used this backup.
     * 
     * @return the lastRestoreTimestamp value.
     */
    public OffsetDateTime lastRestoreTimestamp() {
        return this.lastRestoreTimestamp;
    }

    /**
     * Get the finishedTimestamp property: Timestamp when this backup finished.
     * 
     * @return the finishedTimestamp value.
     */
    public OffsetDateTime finishedTimestamp() {
        return this.finishedTimestamp;
    }

    /**
     * Get the correlationId property: Unique correlation identifier. Please use this along with the timestamp while
     * communicating with Azure support.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the websiteSizeInBytes property: Size of the original web app which has been backed up.
     * 
     * @return the websiteSizeInBytes value.
     */
    public Long websiteSizeInBytes() {
        return this.websiteSizeInBytes;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (databases() != null) {
            databases().forEach(e -> e.validate());
        }
    }
}
