// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * SSL certificate email.
 */
@Fluent
public final class CertificateEmailInner {
    /*
     * Email id.
     */
    @JsonProperty(value = "emailId")
    private String emailId;

    /*
     * Time stamp.
     */
    @JsonProperty(value = "timeStamp")
    private OffsetDateTime timestamp;

    /**
     * Creates an instance of CertificateEmailInner class.
     */
    public CertificateEmailInner() {
    }

    /**
     * Get the emailId property: Email id.
     * 
     * @return the emailId value.
     */
    public String emailId() {
        return this.emailId;
    }

    /**
     * Set the emailId property: Email id.
     * 
     * @param emailId the emailId value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withEmailId(String emailId) {
        this.emailId = emailId;
        return this;
    }

    /**
     * Get the timestamp property: Time stamp.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: Time stamp.
     * 
     * @param timestamp the timestamp value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
