// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * The workflow trigger history.
 */
@Fluent
public final class WorkflowTriggerHistoryInner extends SubResource {
    /*
     * Gets the workflow trigger history properties.
     */
    @JsonProperty(value = "properties")
    private WorkflowTriggerHistoryProperties innerProperties;

    /*
     * Gets the workflow trigger history name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Gets the workflow trigger history type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Creates an instance of WorkflowTriggerHistoryInner class.
     */
    public WorkflowTriggerHistoryInner() {
    }

    /**
     * Get the innerProperties property: Gets the workflow trigger history properties.
     * 
     * @return the innerProperties value.
     */
    private WorkflowTriggerHistoryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Gets the workflow trigger history name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Gets the workflow trigger history type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WorkflowTriggerHistoryInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the scheduledTime property: The scheduled time.
     * 
     * @return the scheduledTime value.
     */
    public OffsetDateTime scheduledTime() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledTime();
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.innerProperties() == null ? null : this.innerProperties().code();
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.innerProperties() == null ? null : this.innerProperties().trackingId();
    }

    /**
     * Get the correlation property: The run correlation.
     * 
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.innerProperties() == null ? null : this.innerProperties().correlation();
    }

    /**
     * Set the correlation property: The run correlation.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowTriggerHistoryInner object itself.
     */
    public WorkflowTriggerHistoryInner withCorrelation(Correlation correlation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowTriggerHistoryProperties();
        }
        this.innerProperties().withCorrelation(correlation);
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to input parameters.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().inputsLink();
    }

    /**
     * Get the outputsLink property: Gets the link to output parameters.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().outputsLink();
    }

    /**
     * Get the fired property: The value indicating whether trigger was fired.
     * 
     * @return the fired value.
     */
    public Boolean fired() {
        return this.innerProperties() == null ? null : this.innerProperties().fired();
    }

    /**
     * Get the run property: Gets the reference to workflow run.
     * 
     * @return the run value.
     */
    public ResourceReference run() {
        return this.innerProperties() == null ? null : this.innerProperties().run();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
