// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.azure.resourcemanager.appservice.fluent.models.CapabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmUsageQuotaInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionKeyInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionLimitsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetRouteInner;
import com.azure.resourcemanager.appservice.models.AppServicePlanPatchResource;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AppServicePlansClient. */
public interface AppServicePlansClient
    extends InnerSupportsGet<AppServicePlanInner>,
        InnerSupportsListing<AppServicePlanInner>,
        InnerSupportsDelete<Void> {
    /**
     * Description for Get all App Service plans for a subscription.
     *
     * @param detailed Specify &lt;code&gt;true&lt;/code&gt; to return all App Service plan properties. The default is
     *     &lt;code&gt;false&lt;/code&gt;, which returns a subset of the properties. Retrieval of all properties may
     *     increase the API latency.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listAsync(Boolean detailed);

    /**
     * Description for Get all App Service plans for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listAsync();

    /**
     * Description for Get all App Service plans for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> list();

    /**
     * Description for Get all App Service plans for a subscription.
     *
     * @param detailed Specify &lt;code&gt;true&lt;/code&gt; to return all App Service plan properties. The default is
     *     &lt;code&gt;false&lt;/code&gt;, which returns a subset of the properties. Retrieval of all properties may
     *     increase the API latency.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> list(Boolean detailed, Context context);

    /**
     * Description for Get all App Service plans in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<AppServicePlanInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Description for Get all App Service plans in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> listByResourceGroup(String resourceGroupName);

    /**
     * Description for Get all App Service plans in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service plans.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<AppServicePlanInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Description for Get an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AppServicePlanInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Get an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Description for Get an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Description for Get an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AppServicePlanInner> getByResourceGroupWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdate(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<AppServicePlanInner>, AppServicePlanInner> beginCreateOrUpdate(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan, Context context);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> createOrUpdateAsync(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner createOrUpdate(String resourceGroupName, String name, AppServicePlanInner appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner createOrUpdate(
        String resourceGroupName, String name, AppServicePlanInner appServicePlan, Context context);

    /**
     * Description for Delete an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Delete an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Description for Delete an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Description for Delete an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AppServicePlanInner>> updateWithResponseAsync(
        String resourceGroupName, String name, AppServicePlanPatchResource appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AppServicePlanInner> updateAsync(
        String resourceGroupName, String name, AppServicePlanPatchResource appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AppServicePlanInner update(String resourceGroupName, String name, AppServicePlanPatchResource appServicePlan);

    /**
     * Description for Creates or updates an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param appServicePlan Details of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return app Service plan.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AppServicePlanInner> updateWithResponse(
        String resourceGroupName, String name, AppServicePlanPatchResource appServicePlan, Context context);

    /**
     * Description for List all capabilities of an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<CapabilityInner>>> listCapabilitiesWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for List all capabilities of an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<CapabilityInner>> listCapabilitiesAsync(String resourceGroupName, String name);

    /**
     * Description for List all capabilities of an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<CapabilityInner> listCapabilities(String resourceGroupName, String name);

    /**
     * Description for List all capabilities of an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Capability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<CapabilityInner>> listCapabilitiesWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> getHybridConnectionWithResponseAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> getHybridConnectionAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner getHybridConnection(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieve a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> getHybridConnectionWithResponse(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteHybridConnectionWithResponseAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteHybridConnectionAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Delete a Hybrid Connection in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Service Bus namespace.
     * @param relayName Name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteHybridConnectionWithResponse(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Get the send key name and value of a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionKeyInner>> listHybridConnectionKeysWithResponseAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Get the send key name and value of a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionKeyInner> listHybridConnectionKeysAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Get the send key name and value of a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionKeyInner listHybridConnectionKeys(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Get the send key name and value of a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName The name of the Service Bus namespace.
     * @param relayName The name of the Service Bus relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection key contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionKeyInner> listHybridConnectionKeysWithResponse(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listWebAppsByHybridConnectionAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listWebAppsByHybridConnection(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Get all apps that use a Hybrid Connection in an App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param namespaceName Name of the Hybrid Connection namespace.
     * @param relayName Name of the Hybrid Connection relay.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listWebAppsByHybridConnection(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionLimitsInner>> getHybridConnectionPlanLimitWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionLimitsInner> getHybridConnectionPlanLimitAsync(String resourceGroupName, String name);

    /**
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionLimitsInner getHybridConnectionPlanLimit(String resourceGroupName, String name);

    /**
     * Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection limits contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionLimitsInner> getHybridConnectionPlanLimitWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name);

    /**
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HybridConnectionInner> listHybridConnections(String resourceGroupName, String name);

    /**
     * Description for Retrieve all Hybrid Connections in use in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HybridConnectionInner> listHybridConnections(String resourceGroupName, String name, Context context);

    /**
     * Description for Restart all apps in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param softRestart Specify &lt;code&gt;true&lt;/code&gt; to perform a soft restart, applies the configuration
     *     settings and restarts the apps if necessary. The default is &lt;code&gt;false&lt;/code&gt;, which always
     *     restarts and reprovisions the apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> restartWebAppsWithResponseAsync(String resourceGroupName, String name, Boolean softRestart);

    /**
     * Description for Restart all apps in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param softRestart Specify &lt;code&gt;true&lt;/code&gt; to perform a soft restart, applies the configuration
     *     settings and restarts the apps if necessary. The default is &lt;code&gt;false&lt;/code&gt;, which always
     *     restarts and reprovisions the apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartWebAppsAsync(String resourceGroupName, String name, Boolean softRestart);

    /**
     * Description for Restart all apps in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartWebAppsAsync(String resourceGroupName, String name);

    /**
     * Description for Restart all apps in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restartWebApps(String resourceGroupName, String name);

    /**
     * Description for Restart all apps in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param softRestart Specify &lt;code&gt;true&lt;/code&gt; to perform a soft restart, applies the configuration
     *     settings and restarts the apps if necessary. The default is &lt;code&gt;false&lt;/code&gt;, which always
     *     restarts and reprovisions the apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> restartWebAppsWithResponse(
        String resourceGroupName, String name, Boolean softRestart, Context context);

    /**
     * Description for Get all apps associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param skipToken Skip to a web app in the list of webapps associated with app service plan. If specified, the
     *     resulting list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list
     *     contains web apps from the start of the list.
     * @param filter Supported filter: $filter=state eq running. Returns only web apps that are currently running.
     * @param top List page size. If specified, results are paged.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listWebAppsAsync(
        String resourceGroupName, String name, String skipToken, String filter, String top);

    /**
     * Description for Get all apps associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listWebAppsAsync(String resourceGroupName, String name);

    /**
     * Description for Get all apps associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listWebApps(String resourceGroupName, String name);

    /**
     * Description for Get all apps associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param skipToken Skip to a web app in the list of webapps associated with app service plan. If specified, the
     *     resulting list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list
     *     contains web apps from the start of the list.
     * @param filter Supported filter: $filter=state eq running. Returns only web apps that are currently running.
     * @param top List page size. If specified, results are paged.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listWebApps(
        String resourceGroupName, String name, String skipToken, String filter, String top, Context context);

    /**
     * Description for Gets all selectable SKUs for a given App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> getServerFarmSkusWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets all selectable SKUs for a given App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> getServerFarmSkusAsync(String resourceGroupName, String name);

    /**
     * Description for Gets all selectable SKUs for a given App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object getServerFarmSkus(String resourceGroupName, String name);

    /**
     * Description for Gets all selectable SKUs for a given App Service Plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> getServerFarmSkusWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets server farm usage information.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     *     $filter=(name.value eq 'Metric1' or name.value eq 'Metric2').
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmUsageQuotaInner> listUsagesAsync(String resourceGroupName, String name, String filter);

    /**
     * Description for Gets server farm usage information.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmUsageQuotaInner> listUsagesAsync(String resourceGroupName, String name);

    /**
     * Description for Gets server farm usage information.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmUsageQuotaInner> listUsages(String resourceGroupName, String name);

    /**
     * Description for Gets server farm usage information.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of App Service Plan.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     *     $filter=(name.value eq 'Metric1' or name.value eq 'Metric2').
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of CSM usage quotas.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmUsageQuotaInner> listUsages(String resourceGroupName, String name, String filter, Context context);

    /**
     * Description for Get all Virtual Networks associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfo.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetInfoInner>>> listVnetsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Get all Virtual Networks associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfo.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetInfoInner>> listVnetsAsync(String resourceGroupName, String name);

    /**
     * Description for Get all Virtual Networks associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfo.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetInfoInner> listVnets(String resourceGroupName, String name);

    /**
     * Description for Get all Virtual Networks associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetInfo.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetInfoInner>> listVnetsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Get a Virtual Network associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetInfoInner>> getVnetFromServerFarmWithResponseAsync(
        String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get a Virtual Network associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetInfoInner> getVnetFromServerFarmAsync(String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get a Virtual Network associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetInfoInner getVnetFromServerFarm(String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get a Virtual Network associated with an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network information contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetInfoInner> getVnetFromServerFarmWithResponse(
        String resourceGroupName, String name, String vnetName, Context context);

    /**
     * Description for Get a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetGatewayInner>> getVnetGatewayWithResponseAsync(
        String resourceGroupName, String name, String vnetName, String gatewayName);

    /**
     * Description for Get a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetGatewayInner> getVnetGatewayAsync(
        String resourceGroupName, String name, String vnetName, String gatewayName);

    /**
     * Description for Get a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetGatewayInner getVnetGateway(String resourceGroupName, String name, String vnetName, String gatewayName);

    /**
     * Description for Get a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetGatewayInner> getVnetGatewayWithResponse(
        String resourceGroupName, String name, String vnetName, String gatewayName, Context context);

    /**
     * Description for Update a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetGatewayInner>> updateVnetGatewayWithResponseAsync(
        String resourceGroupName,
        String name,
        String vnetName,
        String gatewayName,
        VnetGatewayInner connectionEnvelope);

    /**
     * Description for Update a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetGatewayInner> updateVnetGatewayAsync(
        String resourceGroupName,
        String name,
        String vnetName,
        String gatewayName,
        VnetGatewayInner connectionEnvelope);

    /**
     * Description for Update a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetGatewayInner updateVnetGateway(
        String resourceGroupName,
        String name,
        String vnetName,
        String gatewayName,
        VnetGatewayInner connectionEnvelope);

    /**
     * Description for Update a Virtual Network gateway.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param gatewayName Name of the gateway. Only the 'primary' gateway is supported.
     * @param connectionEnvelope Definition of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Virtual Network gateway contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetGatewayInner> updateVnetGatewayWithResponse(
        String resourceGroupName,
        String name,
        String vnetName,
        String gatewayName,
        VnetGatewayInner connectionEnvelope,
        Context context);

    /**
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetRouteInner>>> listRoutesForVnetWithResponseAsync(
        String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetRouteInner>> listRoutesForVnetAsync(String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetRouteInner> listRoutesForVnet(String resourceGroupName, String name, String vnetName);

    /**
     * Description for Get all routes that are associated with a Virtual Network in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetRouteInner>> listRoutesForVnetWithResponse(
        String resourceGroupName, String name, String vnetName, Context context);

    /**
     * Description for Get a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<VnetRouteInner>>> getRouteForVnetWithResponseAsync(
        String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Get a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<VnetRouteInner>> getRouteForVnetAsync(
        String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Get a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<VnetRouteInner> getRouteForVnet(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Get a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of VnetRoute.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<VnetRouteInner>> getRouteForVnetWithResponse(
        String resourceGroupName, String name, String vnetName, String routeName, Context context);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetRouteInner>> createOrUpdateVnetRouteWithResponseAsync(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetRouteInner> createOrUpdateVnetRouteAsync(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetRouteInner createOrUpdateVnetRoute(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetRouteInner> createOrUpdateVnetRouteWithResponse(
        String resourceGroupName,
        String name,
        String vnetName,
        String routeName,
        VnetRouteInner route,
        Context context);

    /**
     * Description for Delete a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteVnetRouteWithResponseAsync(
        String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Delete a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteVnetRouteAsync(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Delete a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteVnetRoute(String resourceGroupName, String name, String vnetName, String routeName);

    /**
     * Description for Delete a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteVnetRouteWithResponse(
        String resourceGroupName, String name, String vnetName, String routeName, Context context);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VnetRouteInner>> updateVnetRouteWithResponseAsync(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VnetRouteInner> updateVnetRouteAsync(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VnetRouteInner updateVnetRoute(
        String resourceGroupName, String name, String vnetName, String routeName, VnetRouteInner route);

    /**
     * Description for Create or update a Virtual Network route in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param vnetName Name of the Virtual Network.
     * @param routeName Name of the Virtual Network route.
     * @param route Definition of the Virtual Network route.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return virtual Network route contract used to pass routing information for a Virtual Network.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VnetRouteInner> updateVnetRouteWithResponse(
        String resourceGroupName,
        String name,
        String vnetName,
        String routeName,
        VnetRouteInner route,
        Context context);

    /**
     * Description for Reboot a worker machine in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> rebootWorkerWithResponseAsync(String resourceGroupName, String name, String workerName);

    /**
     * Description for Reboot a worker machine in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> rebootWorkerAsync(String resourceGroupName, String name, String workerName);

    /**
     * Description for Reboot a worker machine in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rebootWorker(String resourceGroupName, String name, String workerName);

    /**
     * Description for Reboot a worker machine in an App Service plan.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service plan.
     * @param workerName Name of worker machine, which typically starts with RD.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> rebootWorkerWithResponse(String resourceGroupName, String name, String workerName, Context context);
}
