// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ApplicationStack;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackMajorVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** ARM resource for a ApplicationStack. */
@JsonFlatten
@Fluent
public class ApplicationStackResourceInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ApplicationStackResourceInner.class);

    /*
     * Application stack name.
     */
    @JsonProperty(value = "properties.name")
    private String namePropertiesName;

    /*
     * Application stack display name.
     */
    @JsonProperty(value = "properties.display")
    private String display;

    /*
     * Application stack dependency.
     */
    @JsonProperty(value = "properties.dependency")
    private String dependency;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "properties.majorVersions")
    private List<StackMajorVersion> majorVersions;

    /*
     * List of frameworks associated with application stack.
     */
    @JsonProperty(value = "properties.frameworks")
    private List<ApplicationStack> frameworks;

    /*
     * <code>true</code> if this is the stack is deprecated; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "properties.isDeprecated")
    private List<ApplicationStack> isDeprecated;

    /**
     * Get the namePropertiesName property: Application stack name.
     *
     * @return the namePropertiesName value.
     */
    public String namePropertiesName() {
        return this.namePropertiesName;
    }

    /**
     * Set the namePropertiesName property: Application stack name.
     *
     * @param namePropertiesName the namePropertiesName value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withNamePropertiesName(String namePropertiesName) {
        this.namePropertiesName = namePropertiesName;
        return this;
    }

    /**
     * Get the display property: Application stack display name.
     *
     * @return the display value.
     */
    public String display() {
        return this.display;
    }

    /**
     * Set the display property: Application stack display name.
     *
     * @param display the display value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDisplay(String display) {
        this.display = display;
        return this;
    }

    /**
     * Get the dependency property: Application stack dependency.
     *
     * @return the dependency value.
     */
    public String dependency() {
        return this.dependency;
    }

    /**
     * Set the dependency property: Application stack dependency.
     *
     * @param dependency the dependency value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDependency(String dependency) {
        this.dependency = dependency;
        return this;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<StackMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Set the majorVersions property: List of major versions available.
     *
     * @param majorVersions the majorVersions value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withMajorVersions(List<StackMajorVersion> majorVersions) {
        this.majorVersions = majorVersions;
        return this;
    }

    /**
     * Get the frameworks property: List of frameworks associated with application stack.
     *
     * @return the frameworks value.
     */
    public List<ApplicationStack> frameworks() {
        return this.frameworks;
    }

    /**
     * Set the frameworks property: List of frameworks associated with application stack.
     *
     * @param frameworks the frameworks value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withFrameworks(List<ApplicationStack> frameworks) {
        this.frameworks = frameworks;
        return this;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isDeprecated value.
     */
    public List<ApplicationStack> isDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Set the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param isDeprecated the isDeprecated value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withIsDeprecated(List<ApplicationStack> isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ApplicationStackResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
        if (frameworks() != null) {
            frameworks().forEach(e -> e.validate());
        }
        if (isDeprecated() != null) {
            isDeprecated().forEach(e -> e.validate());
        }
    }
}
