// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Function App Stack. */
@JsonFlatten
@Immutable
public class FunctionAppStackInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(FunctionAppStackInner.class);

    /*
     * Function App stack location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Function App stack (display only).
     */
    @JsonProperty(value = "properties.displayText", access = JsonProperty.Access.WRITE_ONLY)
    private String displayText;

    /*
     * Function App stack name.
     */
    @JsonProperty(value = "properties.value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "properties.majorVersions", access = JsonProperty.Access.WRITE_ONLY)
    private List<FunctionAppMajorVersion> majorVersions;

    /*
     * Function App stack preferred OS.
     */
    @JsonProperty(value = "properties.preferredOs", access = JsonProperty.Access.WRITE_ONLY)
    private StackPreferredOs preferredOs;

    /**
     * Get the location property: Function App stack location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the displayText property: Function App stack (display only).
     *
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Get the value property: Function App stack name.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<FunctionAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Get the preferredOs property: Function App stack preferred OS.
     *
     * @return the preferredOs value.
     */
    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    /** {@inheritDoc} */
    @Override
    public FunctionAppStackInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
    }
}
