// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections. */
@JsonFlatten
@Immutable
public class HybridConnectionLimitsInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HybridConnectionLimitsInner.class);

    /*
     * The current number of Hybrid Connections.
     */
    @JsonProperty(value = "properties.current", access = JsonProperty.Access.WRITE_ONLY)
    private Integer current;

    /*
     * The maximum number of Hybrid Connections allowed.
     */
    @JsonProperty(value = "properties.maximum", access = JsonProperty.Access.WRITE_ONLY)
    private Integer maximum;

    /**
     * Get the current property: The current number of Hybrid Connections.
     *
     * @return the current value.
     */
    public Integer current() {
        return this.current;
    }

    /**
     * Get the maximum property: The maximum number of Hybrid Connections allowed.
     *
     * @return the maximum value.
     */
    public Integer maximum() {
        return this.maximum;
    }

    /** {@inheritDoc} */
    @Override
    public HybridConnectionLimitsInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
