// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ApiDefinitionInfo;
import com.azure.resourcemanager.appservice.models.ApiManagementConfig;
import com.azure.resourcemanager.appservice.models.AutoHealRules;
import com.azure.resourcemanager.appservice.models.AzureStorageInfoValue;
import com.azure.resourcemanager.appservice.models.ConnStringInfo;
import com.azure.resourcemanager.appservice.models.CorsSettings;
import com.azure.resourcemanager.appservice.models.Experiments;
import com.azure.resourcemanager.appservice.models.FtpsState;
import com.azure.resourcemanager.appservice.models.HandlerMapping;
import com.azure.resourcemanager.appservice.models.IpSecurityRestriction;
import com.azure.resourcemanager.appservice.models.ManagedPipelineMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ScmType;
import com.azure.resourcemanager.appservice.models.SiteLimits;
import com.azure.resourcemanager.appservice.models.SiteLoadBalancing;
import com.azure.resourcemanager.appservice.models.SiteMachineKey;
import com.azure.resourcemanager.appservice.models.SupportedTlsVersions;
import com.azure.resourcemanager.appservice.models.VirtualApplication;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** Configuration of an App Service app. */
@Fluent
public final class SiteConfigInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SiteConfigInner.class);

    /*
     * Number of workers.
     */
    @JsonProperty(value = "numberOfWorkers")
    private Integer numberOfWorkers;

    /*
     * Default documents.
     */
    @JsonProperty(value = "defaultDocuments")
    private List<String> defaultDocuments;

    /*
     * .NET Framework version.
     */
    @JsonProperty(value = "netFrameworkVersion")
    private String netFrameworkVersion;

    /*
     * Version of PHP.
     */
    @JsonProperty(value = "phpVersion")
    private String phpVersion;

    /*
     * Version of Python.
     */
    @JsonProperty(value = "pythonVersion")
    private String pythonVersion;

    /*
     * Version of Node.js.
     */
    @JsonProperty(value = "nodeVersion")
    private String nodeVersion;

    /*
     * Version of PowerShell.
     */
    @JsonProperty(value = "powerShellVersion")
    private String powerShellVersion;

    /*
     * Linux App Framework and version
     */
    @JsonProperty(value = "linuxFxVersion")
    private String linuxFxVersion;

    /*
     * Xenon App Framework and version
     */
    @JsonProperty(value = "windowsFxVersion")
    private String windowsFxVersion;

    /*
     * <code>true</code> if request tracing is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "requestTracingEnabled")
    private Boolean requestTracingEnabled;

    /*
     * Request tracing expiration time.
     */
    @JsonProperty(value = "requestTracingExpirationTime")
    private OffsetDateTime requestTracingExpirationTime;

    /*
     * <code>true</code> if remote debugging is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "remoteDebuggingEnabled")
    private Boolean remoteDebuggingEnabled;

    /*
     * Remote debugging version.
     */
    @JsonProperty(value = "remoteDebuggingVersion")
    private String remoteDebuggingVersion;

    /*
     * <code>true</code> if HTTP logging is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "httpLoggingEnabled")
    private Boolean httpLoggingEnabled;

    /*
     * HTTP logs directory size limit.
     */
    @JsonProperty(value = "logsDirectorySizeLimit")
    private Integer logsDirectorySizeLimit;

    /*
     * <code>true</code> if detailed error logging is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "detailedErrorLoggingEnabled")
    private Boolean detailedErrorLoggingEnabled;

    /*
     * Publishing user name.
     */
    @JsonProperty(value = "publishingUsername")
    private String publishingUsername;

    /*
     * Application settings.
     */
    @JsonProperty(value = "appSettings")
    private List<NameValuePair> appSettings;

    /*
     * List of Azure Storage Accounts.
     */
    @JsonProperty(value = "azureStorageAccounts")
    private Map<String, AzureStorageInfoValue> azureStorageAccounts;

    /*
     * Connection strings.
     */
    @JsonProperty(value = "connectionStrings")
    private List<ConnStringInfo> connectionStrings;

    /*
     * Site MachineKey.
     */
    @JsonProperty(value = "machineKey", access = JsonProperty.Access.WRITE_ONLY)
    private SiteMachineKey machineKey;

    /*
     * Handler mappings.
     */
    @JsonProperty(value = "handlerMappings")
    private List<HandlerMapping> handlerMappings;

    /*
     * Document root.
     */
    @JsonProperty(value = "documentRoot")
    private String documentRoot;

    /*
     * SCM type.
     */
    @JsonProperty(value = "scmType")
    private ScmType scmType;

    /*
     * <code>true</code> to use 32-bit worker process; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "use32BitWorkerProcess")
    private Boolean use32BitWorkerProcess;

    /*
     * <code>true</code> if WebSocket is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "webSocketsEnabled")
    private Boolean webSocketsEnabled;

    /*
     * <code>true</code> if Always On is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "alwaysOn")
    private Boolean alwaysOn;

    /*
     * Java version.
     */
    @JsonProperty(value = "javaVersion")
    private String javaVersion;

    /*
     * Java container.
     */
    @JsonProperty(value = "javaContainer")
    private String javaContainer;

    /*
     * Java container version.
     */
    @JsonProperty(value = "javaContainerVersion")
    private String javaContainerVersion;

    /*
     * App command line to launch.
     */
    @JsonProperty(value = "appCommandLine")
    private String appCommandLine;

    /*
     * Managed pipeline mode.
     */
    @JsonProperty(value = "managedPipelineMode")
    private ManagedPipelineMode managedPipelineMode;

    /*
     * Virtual applications.
     */
    @JsonProperty(value = "virtualApplications")
    private List<VirtualApplication> virtualApplications;

    /*
     * Site load balancing.
     */
    @JsonProperty(value = "loadBalancing")
    private SiteLoadBalancing loadBalancing;

    /*
     * This is work around for polymorphic types.
     */
    @JsonProperty(value = "experiments")
    private Experiments experiments;

    /*
     * Site limits.
     */
    @JsonProperty(value = "limits")
    private SiteLimits limits;

    /*
     * <code>true</code> if Auto Heal is enabled; otherwise,
     * <code>false</code>.
     */
    @JsonProperty(value = "autoHealEnabled")
    private Boolean autoHealEnabled;

    /*
     * Auto Heal rules.
     */
    @JsonProperty(value = "autoHealRules")
    private AutoHealRules autoHealRules;

    /*
     * Tracing options.
     */
    @JsonProperty(value = "tracingOptions")
    private String tracingOptions;

    /*
     * Virtual Network name.
     */
    @JsonProperty(value = "vnetName")
    private String vnetName;

    /*
     * Virtual Network Route All enabled. This causes all outbound traffic to
     * have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JsonProperty(value = "vnetRouteAllEnabled")
    private Boolean vnetRouteAllEnabled;

    /*
     * The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     */
    @JsonProperty(value = "vnetPrivatePortsCount")
    private Integer vnetPrivatePortsCount;

    /*
     * Cross-Origin Resource Sharing (CORS) settings.
     */
    @JsonProperty(value = "cors")
    private CorsSettings cors;

    /*
     * Push endpoint settings.
     */
    @JsonProperty(value = "push")
    private PushSettingsInner push;

    /*
     * Information about the formal API definition for the app.
     */
    @JsonProperty(value = "apiDefinition")
    private ApiDefinitionInfo apiDefinition;

    /*
     * Azure API management settings linked to the app.
     */
    @JsonProperty(value = "apiManagementConfig")
    private ApiManagementConfig apiManagementConfig;

    /*
     * Auto-swap slot name.
     */
    @JsonProperty(value = "autoSwapSlotName")
    private String autoSwapSlotName;

    /*
     * <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "localMySqlEnabled")
    private Boolean localMySqlEnabled;

    /*
     * Managed Service Identity Id
     */
    @JsonProperty(value = "managedServiceIdentityId")
    private Integer managedServiceIdentityId;

    /*
     * Explicit Managed Service Identity Id
     */
    @JsonProperty(value = "xManagedServiceIdentityId")
    private Integer xManagedServiceIdentityId;

    /*
     * Identity to use for Key Vault Reference authentication.
     */
    @JsonProperty(value = "keyVaultReferenceIdentity")
    private String keyVaultReferenceIdentity;

    /*
     * IP security restrictions for main.
     */
    @JsonProperty(value = "ipSecurityRestrictions")
    private List<IpSecurityRestriction> ipSecurityRestrictions;

    /*
     * IP security restrictions for scm.
     */
    @JsonProperty(value = "scmIpSecurityRestrictions")
    private List<IpSecurityRestriction> scmIpSecurityRestrictions;

    /*
     * IP security restrictions for scm to use main.
     */
    @JsonProperty(value = "scmIpSecurityRestrictionsUseMain")
    private Boolean scmIpSecurityRestrictionsUseMain;

    /*
     * Http20Enabled: configures a web site to allow clients to connect over
     * http2.0
     */
    @JsonProperty(value = "http20Enabled")
    private Boolean http20Enabled;

    /*
     * MinTlsVersion: configures the minimum version of TLS required for SSL
     * requests
     */
    @JsonProperty(value = "minTlsVersion")
    private SupportedTlsVersions minTlsVersion;

    /*
     * ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site
     */
    @JsonProperty(value = "scmMinTlsVersion")
    private SupportedTlsVersions scmMinTlsVersion;

    /*
     * State of FTP / FTPS service
     */
    @JsonProperty(value = "ftpsState")
    private FtpsState ftpsState;

    /*
     * Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    @JsonProperty(value = "preWarmedInstanceCount")
    private Integer preWarmedInstanceCount;

    /*
     * Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    @JsonProperty(value = "functionAppScaleLimit")
    private Integer functionAppScaleLimit;

    /*
     * Health check path
     */
    @JsonProperty(value = "healthCheckPath")
    private String healthCheckPath;

    /*
     * Gets or sets a value indicating whether functions runtime scale
     * monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will
     * instead call to the
     * runtime to get scale status.
     */
    @JsonProperty(value = "functionsRuntimeScaleMonitoringEnabled")
    private Boolean functionsRuntimeScaleMonitoringEnabled;

    /*
     * Sets the time zone a site uses for generating timestamps. Compatible
     * with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app
     * setting takes precedence over this config. For Linux, expects tz
     * database values https://www.iana.org/time-zones (for a quick reference
     * see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For
     * Windows, expects one of the time zones listed under
     * HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time
     * Zones
     */
    @JsonProperty(value = "websiteTimeZone")
    private String websiteTimeZone;

    /*
     * Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    @JsonProperty(value = "minimumElasticInstanceCount")
    private Integer minimumElasticInstanceCount;

    /**
     * Get the numberOfWorkers property: Number of workers.
     *
     * @return the numberOfWorkers value.
     */
    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    /**
     * Set the numberOfWorkers property: Number of workers.
     *
     * @param numberOfWorkers the numberOfWorkers value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
        return this;
    }

    /**
     * Get the defaultDocuments property: Default documents.
     *
     * @return the defaultDocuments value.
     */
    public List<String> defaultDocuments() {
        return this.defaultDocuments;
    }

    /**
     * Set the defaultDocuments property: Default documents.
     *
     * @param defaultDocuments the defaultDocuments value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDefaultDocuments(List<String> defaultDocuments) {
        this.defaultDocuments = defaultDocuments;
        return this;
    }

    /**
     * Get the netFrameworkVersion property: .NET Framework version.
     *
     * @return the netFrameworkVersion value.
     */
    public String netFrameworkVersion() {
        return this.netFrameworkVersion;
    }

    /**
     * Set the netFrameworkVersion property: .NET Framework version.
     *
     * @param netFrameworkVersion the netFrameworkVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNetFrameworkVersion(String netFrameworkVersion) {
        this.netFrameworkVersion = netFrameworkVersion;
        return this;
    }

    /**
     * Get the phpVersion property: Version of PHP.
     *
     * @return the phpVersion value.
     */
    public String phpVersion() {
        return this.phpVersion;
    }

    /**
     * Set the phpVersion property: Version of PHP.
     *
     * @param phpVersion the phpVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPhpVersion(String phpVersion) {
        this.phpVersion = phpVersion;
        return this;
    }

    /**
     * Get the pythonVersion property: Version of Python.
     *
     * @return the pythonVersion value.
     */
    public String pythonVersion() {
        return this.pythonVersion;
    }

    /**
     * Set the pythonVersion property: Version of Python.
     *
     * @param pythonVersion the pythonVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPythonVersion(String pythonVersion) {
        this.pythonVersion = pythonVersion;
        return this;
    }

    /**
     * Get the nodeVersion property: Version of Node.js.
     *
     * @return the nodeVersion value.
     */
    public String nodeVersion() {
        return this.nodeVersion;
    }

    /**
     * Set the nodeVersion property: Version of Node.js.
     *
     * @param nodeVersion the nodeVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    /**
     * Get the powerShellVersion property: Version of PowerShell.
     *
     * @return the powerShellVersion value.
     */
    public String powerShellVersion() {
        return this.powerShellVersion;
    }

    /**
     * Set the powerShellVersion property: Version of PowerShell.
     *
     * @param powerShellVersion the powerShellVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPowerShellVersion(String powerShellVersion) {
        this.powerShellVersion = powerShellVersion;
        return this;
    }

    /**
     * Get the linuxFxVersion property: Linux App Framework and version.
     *
     * @return the linuxFxVersion value.
     */
    public String linuxFxVersion() {
        return this.linuxFxVersion;
    }

    /**
     * Set the linuxFxVersion property: Linux App Framework and version.
     *
     * @param linuxFxVersion the linuxFxVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLinuxFxVersion(String linuxFxVersion) {
        this.linuxFxVersion = linuxFxVersion;
        return this;
    }

    /**
     * Get the windowsFxVersion property: Xenon App Framework and version.
     *
     * @return the windowsFxVersion value.
     */
    public String windowsFxVersion() {
        return this.windowsFxVersion;
    }

    /**
     * Set the windowsFxVersion property: Xenon App Framework and version.
     *
     * @param windowsFxVersion the windowsFxVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWindowsFxVersion(String windowsFxVersion) {
        this.windowsFxVersion = windowsFxVersion;
        return this;
    }

    /**
     * Get the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the requestTracingEnabled value.
     */
    public Boolean requestTracingEnabled() {
        return this.requestTracingEnabled;
    }

    /**
     * Set the requestTracingEnabled property: &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param requestTracingEnabled the requestTracingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRequestTracingEnabled(Boolean requestTracingEnabled) {
        this.requestTracingEnabled = requestTracingEnabled;
        return this;
    }

    /**
     * Get the requestTracingExpirationTime property: Request tracing expiration time.
     *
     * @return the requestTracingExpirationTime value.
     */
    public OffsetDateTime requestTracingExpirationTime() {
        return this.requestTracingExpirationTime;
    }

    /**
     * Set the requestTracingExpirationTime property: Request tracing expiration time.
     *
     * @param requestTracingExpirationTime the requestTracingExpirationTime value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRequestTracingExpirationTime(OffsetDateTime requestTracingExpirationTime) {
        this.requestTracingExpirationTime = requestTracingExpirationTime;
        return this;
    }

    /**
     * Get the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the remoteDebuggingEnabled value.
     */
    public Boolean remoteDebuggingEnabled() {
        return this.remoteDebuggingEnabled;
    }

    /**
     * Set the remoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param remoteDebuggingEnabled the remoteDebuggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRemoteDebuggingEnabled(Boolean remoteDebuggingEnabled) {
        this.remoteDebuggingEnabled = remoteDebuggingEnabled;
        return this;
    }

    /**
     * Get the remoteDebuggingVersion property: Remote debugging version.
     *
     * @return the remoteDebuggingVersion value.
     */
    public String remoteDebuggingVersion() {
        return this.remoteDebuggingVersion;
    }

    /**
     * Set the remoteDebuggingVersion property: Remote debugging version.
     *
     * @param remoteDebuggingVersion the remoteDebuggingVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withRemoteDebuggingVersion(String remoteDebuggingVersion) {
        this.remoteDebuggingVersion = remoteDebuggingVersion;
        return this;
    }

    /**
     * Get the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the httpLoggingEnabled value.
     */
    public Boolean httpLoggingEnabled() {
        return this.httpLoggingEnabled;
    }

    /**
     * Set the httpLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param httpLoggingEnabled the httpLoggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHttpLoggingEnabled(Boolean httpLoggingEnabled) {
        this.httpLoggingEnabled = httpLoggingEnabled;
        return this;
    }

    /**
     * Get the logsDirectorySizeLimit property: HTTP logs directory size limit.
     *
     * @return the logsDirectorySizeLimit value.
     */
    public Integer logsDirectorySizeLimit() {
        return this.logsDirectorySizeLimit;
    }

    /**
     * Set the logsDirectorySizeLimit property: HTTP logs directory size limit.
     *
     * @param logsDirectorySizeLimit the logsDirectorySizeLimit value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLogsDirectorySizeLimit(Integer logsDirectorySizeLimit) {
        this.logsDirectorySizeLimit = logsDirectorySizeLimit;
        return this;
    }

    /**
     * Get the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the detailedErrorLoggingEnabled value.
     */
    public Boolean detailedErrorLoggingEnabled() {
        return this.detailedErrorLoggingEnabled;
    }

    /**
     * Set the detailedErrorLoggingEnabled property: &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @param detailedErrorLoggingEnabled the detailedErrorLoggingEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDetailedErrorLoggingEnabled(Boolean detailedErrorLoggingEnabled) {
        this.detailedErrorLoggingEnabled = detailedErrorLoggingEnabled;
        return this;
    }

    /**
     * Get the publishingUsername property: Publishing user name.
     *
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.publishingUsername;
    }

    /**
     * Set the publishingUsername property: Publishing user name.
     *
     * @param publishingUsername the publishingUsername value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    /**
     * Get the appSettings property: Application settings.
     *
     * @return the appSettings value.
     */
    public List<NameValuePair> appSettings() {
        return this.appSettings;
    }

    /**
     * Set the appSettings property: Application settings.
     *
     * @param appSettings the appSettings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAppSettings(List<NameValuePair> appSettings) {
        this.appSettings = appSettings;
        return this;
    }

    /**
     * Get the azureStorageAccounts property: List of Azure Storage Accounts.
     *
     * @return the azureStorageAccounts value.
     */
    public Map<String, AzureStorageInfoValue> azureStorageAccounts() {
        return this.azureStorageAccounts;
    }

    /**
     * Set the azureStorageAccounts property: List of Azure Storage Accounts.
     *
     * @param azureStorageAccounts the azureStorageAccounts value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAzureStorageAccounts(Map<String, AzureStorageInfoValue> azureStorageAccounts) {
        this.azureStorageAccounts = azureStorageAccounts;
        return this;
    }

    /**
     * Get the connectionStrings property: Connection strings.
     *
     * @return the connectionStrings value.
     */
    public List<ConnStringInfo> connectionStrings() {
        return this.connectionStrings;
    }

    /**
     * Set the connectionStrings property: Connection strings.
     *
     * @param connectionStrings the connectionStrings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withConnectionStrings(List<ConnStringInfo> connectionStrings) {
        this.connectionStrings = connectionStrings;
        return this;
    }

    /**
     * Get the machineKey property: Site MachineKey.
     *
     * @return the machineKey value.
     */
    public SiteMachineKey machineKey() {
        return this.machineKey;
    }

    /**
     * Get the handlerMappings property: Handler mappings.
     *
     * @return the handlerMappings value.
     */
    public List<HandlerMapping> handlerMappings() {
        return this.handlerMappings;
    }

    /**
     * Set the handlerMappings property: Handler mappings.
     *
     * @param handlerMappings the handlerMappings value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHandlerMappings(List<HandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        return this;
    }

    /**
     * Get the documentRoot property: Document root.
     *
     * @return the documentRoot value.
     */
    public String documentRoot() {
        return this.documentRoot;
    }

    /**
     * Set the documentRoot property: Document root.
     *
     * @param documentRoot the documentRoot value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withDocumentRoot(String documentRoot) {
        this.documentRoot = documentRoot;
        return this;
    }

    /**
     * Get the scmType property: SCM type.
     *
     * @return the scmType value.
     */
    public ScmType scmType() {
        return this.scmType;
    }

    /**
     * Set the scmType property: SCM type.
     *
     * @param scmType the scmType value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmType(ScmType scmType) {
        this.scmType = scmType;
        return this;
    }

    /**
     * Get the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the use32BitWorkerProcess value.
     */
    public Boolean use32BitWorkerProcess() {
        return this.use32BitWorkerProcess;
    }

    /**
     * Set the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param use32BitWorkerProcess the use32BitWorkerProcess value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withUse32BitWorkerProcess(Boolean use32BitWorkerProcess) {
        this.use32BitWorkerProcess = use32BitWorkerProcess;
        return this;
    }

    /**
     * Get the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the webSocketsEnabled value.
     */
    public Boolean webSocketsEnabled() {
        return this.webSocketsEnabled;
    }

    /**
     * Set the webSocketsEnabled property: &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param webSocketsEnabled the webSocketsEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWebSocketsEnabled(Boolean webSocketsEnabled) {
        this.webSocketsEnabled = webSocketsEnabled;
        return this;
    }

    /**
     * Get the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the alwaysOn value.
     */
    public Boolean alwaysOn() {
        return this.alwaysOn;
    }

    /**
     * Set the alwaysOn property: &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param alwaysOn the alwaysOn value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAlwaysOn(Boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
        return this;
    }

    /**
     * Get the javaVersion property: Java version.
     *
     * @return the javaVersion value.
     */
    public String javaVersion() {
        return this.javaVersion;
    }

    /**
     * Set the javaVersion property: Java version.
     *
     * @param javaVersion the javaVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    /**
     * Get the javaContainer property: Java container.
     *
     * @return the javaContainer value.
     */
    public String javaContainer() {
        return this.javaContainer;
    }

    /**
     * Set the javaContainer property: Java container.
     *
     * @param javaContainer the javaContainer value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaContainer(String javaContainer) {
        this.javaContainer = javaContainer;
        return this;
    }

    /**
     * Get the javaContainerVersion property: Java container version.
     *
     * @return the javaContainerVersion value.
     */
    public String javaContainerVersion() {
        return this.javaContainerVersion;
    }

    /**
     * Set the javaContainerVersion property: Java container version.
     *
     * @param javaContainerVersion the javaContainerVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withJavaContainerVersion(String javaContainerVersion) {
        this.javaContainerVersion = javaContainerVersion;
        return this;
    }

    /**
     * Get the appCommandLine property: App command line to launch.
     *
     * @return the appCommandLine value.
     */
    public String appCommandLine() {
        return this.appCommandLine;
    }

    /**
     * Set the appCommandLine property: App command line to launch.
     *
     * @param appCommandLine the appCommandLine value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAppCommandLine(String appCommandLine) {
        this.appCommandLine = appCommandLine;
        return this;
    }

    /**
     * Get the managedPipelineMode property: Managed pipeline mode.
     *
     * @return the managedPipelineMode value.
     */
    public ManagedPipelineMode managedPipelineMode() {
        return this.managedPipelineMode;
    }

    /**
     * Set the managedPipelineMode property: Managed pipeline mode.
     *
     * @param managedPipelineMode the managedPipelineMode value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        this.managedPipelineMode = managedPipelineMode;
        return this;
    }

    /**
     * Get the virtualApplications property: Virtual applications.
     *
     * @return the virtualApplications value.
     */
    public List<VirtualApplication> virtualApplications() {
        return this.virtualApplications;
    }

    /**
     * Set the virtualApplications property: Virtual applications.
     *
     * @param virtualApplications the virtualApplications value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVirtualApplications(List<VirtualApplication> virtualApplications) {
        this.virtualApplications = virtualApplications;
        return this;
    }

    /**
     * Get the loadBalancing property: Site load balancing.
     *
     * @return the loadBalancing value.
     */
    public SiteLoadBalancing loadBalancing() {
        return this.loadBalancing;
    }

    /**
     * Set the loadBalancing property: Site load balancing.
     *
     * @param loadBalancing the loadBalancing value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLoadBalancing(SiteLoadBalancing loadBalancing) {
        this.loadBalancing = loadBalancing;
        return this;
    }

    /**
     * Get the experiments property: This is work around for polymorphic types.
     *
     * @return the experiments value.
     */
    public Experiments experiments() {
        return this.experiments;
    }

    /**
     * Set the experiments property: This is work around for polymorphic types.
     *
     * @param experiments the experiments value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withExperiments(Experiments experiments) {
        this.experiments = experiments;
        return this;
    }

    /**
     * Get the limits property: Site limits.
     *
     * @return the limits value.
     */
    public SiteLimits limits() {
        return this.limits;
    }

    /**
     * Set the limits property: Site limits.
     *
     * @param limits the limits value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLimits(SiteLimits limits) {
        this.limits = limits;
        return this;
    }

    /**
     * Get the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the autoHealEnabled value.
     */
    public Boolean autoHealEnabled() {
        return this.autoHealEnabled;
    }

    /**
     * Set the autoHealEnabled property: &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param autoHealEnabled the autoHealEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoHealEnabled(Boolean autoHealEnabled) {
        this.autoHealEnabled = autoHealEnabled;
        return this;
    }

    /**
     * Get the autoHealRules property: Auto Heal rules.
     *
     * @return the autoHealRules value.
     */
    public AutoHealRules autoHealRules() {
        return this.autoHealRules;
    }

    /**
     * Set the autoHealRules property: Auto Heal rules.
     *
     * @param autoHealRules the autoHealRules value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoHealRules(AutoHealRules autoHealRules) {
        this.autoHealRules = autoHealRules;
        return this;
    }

    /**
     * Get the tracingOptions property: Tracing options.
     *
     * @return the tracingOptions value.
     */
    public String tracingOptions() {
        return this.tracingOptions;
    }

    /**
     * Set the tracingOptions property: Tracing options.
     *
     * @param tracingOptions the tracingOptions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withTracingOptions(String tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    /**
     * Get the vnetName property: Virtual Network name.
     *
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName property: Virtual Network name.
     *
     * @param vnetName the vnetName value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     *
     * @return the vnetRouteAllEnabled value.
     */
    public Boolean vnetRouteAllEnabled() {
        return this.vnetRouteAllEnabled;
    }

    /**
     * Set the vnetRouteAllEnabled property: Virtual Network Route All enabled. This causes all outbound traffic to have
     * Virtual Network Security Groups and User Defined Routes applied.
     *
     * @param vnetRouteAllEnabled the vnetRouteAllEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetRouteAllEnabled(Boolean vnetRouteAllEnabled) {
        this.vnetRouteAllEnabled = vnetRouteAllEnabled;
        return this;
    }

    /**
     * Get the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     *
     * @return the vnetPrivatePortsCount value.
     */
    public Integer vnetPrivatePortsCount() {
        return this.vnetPrivatePortsCount;
    }

    /**
     * Set the vnetPrivatePortsCount property: The number of private ports assigned to this app. These will be assigned
     * dynamically on runtime.
     *
     * @param vnetPrivatePortsCount the vnetPrivatePortsCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withVnetPrivatePortsCount(Integer vnetPrivatePortsCount) {
        this.vnetPrivatePortsCount = vnetPrivatePortsCount;
        return this;
    }

    /**
     * Get the cors property: Cross-Origin Resource Sharing (CORS) settings.
     *
     * @return the cors value.
     */
    public CorsSettings cors() {
        return this.cors;
    }

    /**
     * Set the cors property: Cross-Origin Resource Sharing (CORS) settings.
     *
     * @param cors the cors value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withCors(CorsSettings cors) {
        this.cors = cors;
        return this;
    }

    /**
     * Get the push property: Push endpoint settings.
     *
     * @return the push value.
     */
    public PushSettingsInner push() {
        return this.push;
    }

    /**
     * Set the push property: Push endpoint settings.
     *
     * @param push the push value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPush(PushSettingsInner push) {
        this.push = push;
        return this;
    }

    /**
     * Get the apiDefinition property: Information about the formal API definition for the app.
     *
     * @return the apiDefinition value.
     */
    public ApiDefinitionInfo apiDefinition() {
        return this.apiDefinition;
    }

    /**
     * Set the apiDefinition property: Information about the formal API definition for the app.
     *
     * @param apiDefinition the apiDefinition value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withApiDefinition(ApiDefinitionInfo apiDefinition) {
        this.apiDefinition = apiDefinition;
        return this;
    }

    /**
     * Get the apiManagementConfig property: Azure API management settings linked to the app.
     *
     * @return the apiManagementConfig value.
     */
    public ApiManagementConfig apiManagementConfig() {
        return this.apiManagementConfig;
    }

    /**
     * Set the apiManagementConfig property: Azure API management settings linked to the app.
     *
     * @param apiManagementConfig the apiManagementConfig value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withApiManagementConfig(ApiManagementConfig apiManagementConfig) {
        this.apiManagementConfig = apiManagementConfig;
        return this;
    }

    /**
     * Get the autoSwapSlotName property: Auto-swap slot name.
     *
     * @return the autoSwapSlotName value.
     */
    public String autoSwapSlotName() {
        return this.autoSwapSlotName;
    }

    /**
     * Set the autoSwapSlotName property: Auto-swap slot name.
     *
     * @param autoSwapSlotName the autoSwapSlotName value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withAutoSwapSlotName(String autoSwapSlotName) {
        this.autoSwapSlotName = autoSwapSlotName;
        return this;
    }

    /**
     * Get the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the localMySqlEnabled value.
     */
    public Boolean localMySqlEnabled() {
        return this.localMySqlEnabled;
    }

    /**
     * Set the localMySqlEnabled property: &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param localMySqlEnabled the localMySqlEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withLocalMySqlEnabled(Boolean localMySqlEnabled) {
        this.localMySqlEnabled = localMySqlEnabled;
        return this;
    }

    /**
     * Get the managedServiceIdentityId property: Managed Service Identity Id.
     *
     * @return the managedServiceIdentityId value.
     */
    public Integer managedServiceIdentityId() {
        return this.managedServiceIdentityId;
    }

    /**
     * Set the managedServiceIdentityId property: Managed Service Identity Id.
     *
     * @param managedServiceIdentityId the managedServiceIdentityId value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withManagedServiceIdentityId(Integer managedServiceIdentityId) {
        this.managedServiceIdentityId = managedServiceIdentityId;
        return this;
    }

    /**
     * Get the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     *
     * @return the xManagedServiceIdentityId value.
     */
    public Integer xManagedServiceIdentityId() {
        return this.xManagedServiceIdentityId;
    }

    /**
     * Set the xManagedServiceIdentityId property: Explicit Managed Service Identity Id.
     *
     * @param xManagedServiceIdentityId the xManagedServiceIdentityId value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withXManagedServiceIdentityId(Integer xManagedServiceIdentityId) {
        this.xManagedServiceIdentityId = xManagedServiceIdentityId;
        return this;
    }

    /**
     * Get the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     *
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Set the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     *
     * @param keyVaultReferenceIdentity the keyVaultReferenceIdentity value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    /**
     * Get the ipSecurityRestrictions property: IP security restrictions for main.
     *
     * @return the ipSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> ipSecurityRestrictions() {
        return this.ipSecurityRestrictions;
    }

    /**
     * Set the ipSecurityRestrictions property: IP security restrictions for main.
     *
     * @param ipSecurityRestrictions the ipSecurityRestrictions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withIpSecurityRestrictions(List<IpSecurityRestriction> ipSecurityRestrictions) {
        this.ipSecurityRestrictions = ipSecurityRestrictions;
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictions property: IP security restrictions for scm.
     *
     * @return the scmIpSecurityRestrictions value.
     */
    public List<IpSecurityRestriction> scmIpSecurityRestrictions() {
        return this.scmIpSecurityRestrictions;
    }

    /**
     * Set the scmIpSecurityRestrictions property: IP security restrictions for scm.
     *
     * @param scmIpSecurityRestrictions the scmIpSecurityRestrictions value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmIpSecurityRestrictions(List<IpSecurityRestriction> scmIpSecurityRestrictions) {
        this.scmIpSecurityRestrictions = scmIpSecurityRestrictions;
        return this;
    }

    /**
     * Get the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     *
     * @return the scmIpSecurityRestrictionsUseMain value.
     */
    public Boolean scmIpSecurityRestrictionsUseMain() {
        return this.scmIpSecurityRestrictionsUseMain;
    }

    /**
     * Set the scmIpSecurityRestrictionsUseMain property: IP security restrictions for scm to use main.
     *
     * @param scmIpSecurityRestrictionsUseMain the scmIpSecurityRestrictionsUseMain value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmIpSecurityRestrictionsUseMain(Boolean scmIpSecurityRestrictionsUseMain) {
        this.scmIpSecurityRestrictionsUseMain = scmIpSecurityRestrictionsUseMain;
        return this;
    }

    /**
     * Get the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     *
     * @return the http20Enabled value.
     */
    public Boolean http20Enabled() {
        return this.http20Enabled;
    }

    /**
     * Set the http20Enabled property: Http20Enabled: configures a web site to allow clients to connect over http2.0.
     *
     * @param http20Enabled the http20Enabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHttp20Enabled(Boolean http20Enabled) {
        this.http20Enabled = http20Enabled;
        return this;
    }

    /**
     * Get the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     *
     * @return the minTlsVersion value.
     */
    public SupportedTlsVersions minTlsVersion() {
        return this.minTlsVersion;
    }

    /**
     * Set the minTlsVersion property: MinTlsVersion: configures the minimum version of TLS required for SSL requests.
     *
     * @param minTlsVersion the minTlsVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMinTlsVersion(SupportedTlsVersions minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
        return this;
    }

    /**
     * Get the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     *
     * @return the scmMinTlsVersion value.
     */
    public SupportedTlsVersions scmMinTlsVersion() {
        return this.scmMinTlsVersion;
    }

    /**
     * Set the scmMinTlsVersion property: ScmMinTlsVersion: configures the minimum version of TLS required for SSL
     * requests for SCM site.
     *
     * @param scmMinTlsVersion the scmMinTlsVersion value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withScmMinTlsVersion(SupportedTlsVersions scmMinTlsVersion) {
        this.scmMinTlsVersion = scmMinTlsVersion;
        return this;
    }

    /**
     * Get the ftpsState property: State of FTP / FTPS service.
     *
     * @return the ftpsState value.
     */
    public FtpsState ftpsState() {
        return this.ftpsState;
    }

    /**
     * Set the ftpsState property: State of FTP / FTPS service.
     *
     * @param ftpsState the ftpsState value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFtpsState(FtpsState ftpsState) {
        this.ftpsState = ftpsState;
        return this;
    }

    /**
     * Get the preWarmedInstanceCount property: Number of preWarmed instances. This setting only applies to the
     * Consumption and Elastic Plans.
     *
     * @return the preWarmedInstanceCount value.
     */
    public Integer preWarmedInstanceCount() {
        return this.preWarmedInstanceCount;
    }

    /**
     * Set the preWarmedInstanceCount property: Number of preWarmed instances. This setting only applies to the
     * Consumption and Elastic Plans.
     *
     * @param preWarmedInstanceCount the preWarmedInstanceCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withPreWarmedInstanceCount(Integer preWarmedInstanceCount) {
        this.preWarmedInstanceCount = preWarmedInstanceCount;
        return this;
    }

    /**
     * Get the functionAppScaleLimit property: Maximum number of workers that a site can scale out to. This setting only
     * applies to the Consumption and Elastic Premium Plans.
     *
     * @return the functionAppScaleLimit value.
     */
    public Integer functionAppScaleLimit() {
        return this.functionAppScaleLimit;
    }

    /**
     * Set the functionAppScaleLimit property: Maximum number of workers that a site can scale out to. This setting only
     * applies to the Consumption and Elastic Premium Plans.
     *
     * @param functionAppScaleLimit the functionAppScaleLimit value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFunctionAppScaleLimit(Integer functionAppScaleLimit) {
        this.functionAppScaleLimit = functionAppScaleLimit;
        return this;
    }

    /**
     * Get the healthCheckPath property: Health check path.
     *
     * @return the healthCheckPath value.
     */
    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    /**
     * Set the healthCheckPath property: Health check path.
     *
     * @param healthCheckPath the healthCheckPath value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
        return this;
    }

    /**
     * Get the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled, the ScaleController will not monitor event sources directly,
     * but will instead call to the runtime to get scale status.
     *
     * @return the functionsRuntimeScaleMonitoringEnabled value.
     */
    public Boolean functionsRuntimeScaleMonitoringEnabled() {
        return this.functionsRuntimeScaleMonitoringEnabled;
    }

    /**
     * Set the functionsRuntimeScaleMonitoringEnabled property: Gets or sets a value indicating whether functions
     * runtime scale monitoring is enabled. When enabled, the ScaleController will not monitor event sources directly,
     * but will instead call to the runtime to get scale status.
     *
     * @param functionsRuntimeScaleMonitoringEnabled the functionsRuntimeScaleMonitoringEnabled value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withFunctionsRuntimeScaleMonitoringEnabled(Boolean functionsRuntimeScaleMonitoringEnabled) {
        this.functionsRuntimeScaleMonitoringEnabled = functionsRuntimeScaleMonitoringEnabled;
        return this;
    }

    /**
     * Get the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     *
     * @return the websiteTimeZone value.
     */
    public String websiteTimeZone() {
        return this.websiteTimeZone;
    }

    /**
     * Set the websiteTimeZone property: Sets the time zone a site uses for generating timestamps. Compatible with Linux
     * and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux,
     * expects tz database values https://www.iana.org/time-zones (for a quick reference see
     * https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed
     * under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     *
     * @param websiteTimeZone the websiteTimeZone value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withWebsiteTimeZone(String websiteTimeZone) {
        this.websiteTimeZone = websiteTimeZone;
        return this;
    }

    /**
     * Get the minimumElasticInstanceCount property: Number of minimum instance count for a site This setting only
     * applies to the Elastic Plans.
     *
     * @return the minimumElasticInstanceCount value.
     */
    public Integer minimumElasticInstanceCount() {
        return this.minimumElasticInstanceCount;
    }

    /**
     * Set the minimumElasticInstanceCount property: Number of minimum instance count for a site This setting only
     * applies to the Elastic Plans.
     *
     * @param minimumElasticInstanceCount the minimumElasticInstanceCount value to set.
     * @return the SiteConfigInner object itself.
     */
    public SiteConfigInner withMinimumElasticInstanceCount(Integer minimumElasticInstanceCount) {
        this.minimumElasticInstanceCount = minimumElasticInstanceCount;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appSettings() != null) {
            appSettings().forEach(e -> e.validate());
        }
        if (azureStorageAccounts() != null) {
            azureStorageAccounts()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (connectionStrings() != null) {
            connectionStrings().forEach(e -> e.validate());
        }
        if (machineKey() != null) {
            machineKey().validate();
        }
        if (handlerMappings() != null) {
            handlerMappings().forEach(e -> e.validate());
        }
        if (virtualApplications() != null) {
            virtualApplications().forEach(e -> e.validate());
        }
        if (experiments() != null) {
            experiments().validate();
        }
        if (limits() != null) {
            limits().validate();
        }
        if (autoHealRules() != null) {
            autoHealRules().validate();
        }
        if (cors() != null) {
            cors().validate();
        }
        if (push() != null) {
            push().validate();
        }
        if (apiDefinition() != null) {
            apiDefinition().validate();
        }
        if (apiManagementConfig() != null) {
            apiManagementConfig().validate();
        }
        if (ipSecurityRestrictions() != null) {
            ipSecurityRestrictions().forEach(e -> e.validate());
        }
        if (scmIpSecurityRestrictions() != null) {
            scmIpSecurityRestrictions().forEach(e -> e.validate());
        }
    }
}
