// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A snapshot of a web app configuration. */
@JsonFlatten
@Immutable
public class SiteConfigurationSnapshotInfoInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SiteConfigurationSnapshotInfoInner.class);

    /*
     * The time the snapshot was taken.
     */
    @JsonProperty(value = "properties.time", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime time;

    /*
     * The id of the snapshot
     */
    @JsonProperty(value = "properties.snapshotId", access = JsonProperty.Access.WRITE_ONLY)
    private Integer snapshotId;

    /**
     * Get the time property: The time the snapshot was taken.
     *
     * @return the time value.
     */
    public OffsetDateTime time() {
        return this.time;
    }

    /**
     * Get the snapshotId property: The id of the snapshot.
     *
     * @return the snapshotId value.
     */
    public Integer snapshotId() {
        return this.snapshotId;
    }

    /** {@inheritDoc} */
    @Override
    public SiteConfigurationSnapshotInfoInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
