// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.TriggerTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static Site Function Overview ARM resource. */
@JsonFlatten
@Immutable
public class StaticSiteFunctionOverviewArmResourceInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(StaticSiteFunctionOverviewArmResourceInner.class);

    /*
     * The name for the function
     */
    @JsonProperty(value = "properties.functionName", access = JsonProperty.Access.WRITE_ONLY)
    private String functionName;

    /*
     * The trigger type of the function
     */
    @JsonProperty(value = "properties.triggerType", access = JsonProperty.Access.WRITE_ONLY)
    private TriggerTypes triggerType;

    /**
     * Get the functionName property: The name for the function.
     *
     * @return the functionName value.
     */
    public String functionName() {
        return this.functionName;
    }

    /**
     * Get the triggerType property: The trigger type of the function.
     *
     * @return the triggerType value.
     */
    public TriggerTypes triggerType() {
        return this.triggerType;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteFunctionOverviewArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
