// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Static sites user roles invitation link resource. */
@JsonFlatten
@Immutable
public class StaticSiteUserInvitationResponseResourceInner extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSiteUserInvitationResponseResourceInner.class);

    /*
     * The expiration time of the invitation
     */
    @JsonProperty(value = "properties.expiresOn", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expiresOn;

    /*
     * The url for the invitation link
     */
    @JsonProperty(value = "properties.invitationUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String invitationUrl;

    /**
     * Get the expiresOn property: The expiration time of the invitation.
     *
     * @return the expiresOn value.
     */
    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    /**
     * Get the invitationUrl property: The url for the invitation link.
     *
     * @return the invitationUrl value.
     */
    public String invitationUrl() {
        return this.invitationUrl;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteUserInvitationResponseResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
