// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Preview for the Static Site Workflow to be generated. */
@JsonFlatten
@Immutable
public class StaticSitesWorkflowPreviewInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(StaticSitesWorkflowPreviewInner.class);

    /*
     * The path for the workflow file to be generated
     */
    @JsonProperty(value = "properties.path", access = JsonProperty.Access.WRITE_ONLY)
    private String path;

    /*
     * The contents for the workflow file to be generated
     */
    @JsonProperty(value = "properties.contents", access = JsonProperty.Access.WRITE_ONLY)
    private String contents;

    /**
     * Get the path property: The path for the workflow file to be generated.
     *
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Get the contents property: The contents for the workflow file to be generated.
     *
     * @return the contents value.
     */
    public String contents() {
        return this.contents;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSitesWorkflowPreviewInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
