// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** User credentials used for publishing activity. */
@JsonFlatten
@Fluent
public class UserInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(UserInner.class);

    /*
     * Username used for publishing.
     */
    @JsonProperty(value = "properties.publishingUserName")
    private String publishingUsername;

    /*
     * Password used for publishing.
     */
    @JsonProperty(value = "properties.publishingPassword")
    private String publishingPassword;

    /*
     * Password hash used for publishing.
     */
    @JsonProperty(value = "properties.publishingPasswordHash")
    private String publishingPasswordHash;

    /*
     * Password hash salt used for publishing.
     */
    @JsonProperty(value = "properties.publishingPasswordHashSalt")
    private String publishingPasswordHashSalt;

    /*
     * Url of SCM site.
     */
    @JsonProperty(value = "properties.scmUri")
    private String scmUri;

    /**
     * Get the publishingUsername property: Username used for publishing.
     *
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.publishingUsername;
    }

    /**
     * Set the publishingUsername property: Username used for publishing.
     *
     * @param publishingUsername the publishingUsername value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    /**
     * Get the publishingPassword property: Password used for publishing.
     *
     * @return the publishingPassword value.
     */
    public String publishingPassword() {
        return this.publishingPassword;
    }

    /**
     * Set the publishingPassword property: Password used for publishing.
     *
     * @param publishingPassword the publishingPassword value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPassword(String publishingPassword) {
        this.publishingPassword = publishingPassword;
        return this;
    }

    /**
     * Get the publishingPasswordHash property: Password hash used for publishing.
     *
     * @return the publishingPasswordHash value.
     */
    public String publishingPasswordHash() {
        return this.publishingPasswordHash;
    }

    /**
     * Set the publishingPasswordHash property: Password hash used for publishing.
     *
     * @param publishingPasswordHash the publishingPasswordHash value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPasswordHash(String publishingPasswordHash) {
        this.publishingPasswordHash = publishingPasswordHash;
        return this;
    }

    /**
     * Get the publishingPasswordHashSalt property: Password hash salt used for publishing.
     *
     * @return the publishingPasswordHashSalt value.
     */
    public String publishingPasswordHashSalt() {
        return this.publishingPasswordHashSalt;
    }

    /**
     * Set the publishingPasswordHashSalt property: Password hash salt used for publishing.
     *
     * @param publishingPasswordHashSalt the publishingPasswordHashSalt value to set.
     * @return the UserInner object itself.
     */
    public UserInner withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        this.publishingPasswordHashSalt = publishingPasswordHashSalt;
        return this;
    }

    /**
     * Get the scmUri property: Url of SCM site.
     *
     * @return the scmUri value.
     */
    public String scmUri() {
        return this.scmUri;
    }

    /**
     * Set the scmUri property: Url of SCM site.
     *
     * @param scmUri the scmUri value to set.
     * @return the UserInner object itself.
     */
    public UserInner withScmUri(String scmUri) {
        this.scmUri = scmUri;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public UserInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
