// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package. */
@JsonFlatten
@Fluent
public class VnetGatewayInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VnetGatewayInner.class);

    /*
     * The Virtual Network name.
     */
    @JsonProperty(value = "properties.vnetName")
    private String vnetName;

    /*
     * The URI where the VPN package can be downloaded.
     */
    @JsonProperty(value = "properties.vpnPackageUri")
    private String vpnPackageUri;

    /**
     * Get the vnetName property: The Virtual Network name.
     *
     * @return the vnetName value.
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName property: The Virtual Network name.
     *
     * @param vnetName the vnetName value to set.
     * @return the VnetGatewayInner object itself.
     */
    public VnetGatewayInner withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vpnPackageUri property: The URI where the VPN package can be downloaded.
     *
     * @return the vpnPackageUri value.
     */
    public String vpnPackageUri() {
        return this.vpnPackageUri;
    }

    /**
     * Set the vpnPackageUri property: The URI where the VPN package can be downloaded.
     *
     * @param vpnPackageUri the vpnPackageUri value to set.
     * @return the VnetGatewayInner object itself.
     */
    public VnetGatewayInner withVpnPackageUri(String vpnPackageUri) {
        this.vpnPackageUri = vpnPackageUri;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VnetGatewayInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
