// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VnetValidationTestFailure;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A class that describes the reason for a validation failure. */
@JsonFlatten
@Fluent
public class VnetValidationFailureDetailsInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(VnetValidationFailureDetailsInner.class);

    /*
     * Text describing the validation outcome.
     */
    @JsonProperty(value = "properties.message")
    private String message;

    /*
     * A flag describing whether or not validation failed.
     */
    @JsonProperty(value = "properties.failed")
    private Boolean failed;

    /*
     * A list of tests that failed in the validation.
     */
    @JsonProperty(value = "properties.failedTests")
    private List<VnetValidationTestFailure> failedTests;

    /*
     * A list of warnings generated during validation.
     */
    @JsonProperty(value = "properties.warnings")
    private List<VnetValidationTestFailure> warnings;

    /**
     * Get the message property: Text describing the validation outcome.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Text describing the validation outcome.
     *
     * @param message the message value to set.
     * @return the VnetValidationFailureDetailsInner object itself.
     */
    public VnetValidationFailureDetailsInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the failed property: A flag describing whether or not validation failed.
     *
     * @return the failed value.
     */
    public Boolean failed() {
        return this.failed;
    }

    /**
     * Set the failed property: A flag describing whether or not validation failed.
     *
     * @param failed the failed value to set.
     * @return the VnetValidationFailureDetailsInner object itself.
     */
    public VnetValidationFailureDetailsInner withFailed(Boolean failed) {
        this.failed = failed;
        return this;
    }

    /**
     * Get the failedTests property: A list of tests that failed in the validation.
     *
     * @return the failedTests value.
     */
    public List<VnetValidationTestFailure> failedTests() {
        return this.failedTests;
    }

    /**
     * Set the failedTests property: A list of tests that failed in the validation.
     *
     * @param failedTests the failedTests value to set.
     * @return the VnetValidationFailureDetailsInner object itself.
     */
    public VnetValidationFailureDetailsInner withFailedTests(List<VnetValidationTestFailure> failedTests) {
        this.failedTests = failedTests;
        return this;
    }

    /**
     * Get the warnings property: A list of warnings generated during validation.
     *
     * @return the warnings value.
     */
    public List<VnetValidationTestFailure> warnings() {
        return this.warnings;
    }

    /**
     * Set the warnings property: A list of warnings generated during validation.
     *
     * @param warnings the warnings value to set.
     * @return the VnetValidationFailureDetailsInner object itself.
     */
    public VnetValidationFailureDetailsInner withWarnings(List<VnetValidationTestFailure> warnings) {
        this.warnings = warnings;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public VnetValidationFailureDetailsInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (failedTests() != null) {
            failedTests().forEach(e -> e.validate());
        }
        if (warnings() != null) {
            warnings().forEach(e -> e.validate());
        }
    }
}
