// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Web App stack. */
@JsonFlatten
@Immutable
public class WebAppStackInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(WebAppStackInner.class);

    /*
     * Web App stack location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Web App stack (display only).
     */
    @JsonProperty(value = "properties.displayText", access = JsonProperty.Access.WRITE_ONLY)
    private String displayText;

    /*
     * Web App stack name.
     */
    @JsonProperty(value = "properties.value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "properties.majorVersions", access = JsonProperty.Access.WRITE_ONLY)
    private List<WebAppMajorVersion> majorVersions;

    /*
     * Web App stack preferred OS.
     */
    @JsonProperty(value = "properties.preferredOs", access = JsonProperty.Access.WRITE_ONLY)
    private StackPreferredOs preferredOs;

    /**
     * Get the location property: Web App stack location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the displayText property: Web App stack (display only).
     *
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Get the value property: Web App stack name.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<WebAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Get the preferredOs property: Web App stack preferred OS.
     *
     * @return the preferredOs value.
     */
    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    /** {@inheritDoc} */
    @Override
    public WebAppStackInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
    }
}
