// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AuthPlatform model. */
@JsonFlatten
@Fluent
public class AuthPlatform extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AuthPlatform.class);

    /*
     * The enabled property.
     */
    @JsonProperty(value = "properties.enabled")
    private Boolean enabled;

    /*
     * The runtimeVersion property.
     */
    @JsonProperty(value = "properties.runtimeVersion")
    private String runtimeVersion;

    /*
     * The configFilePath property.
     */
    @JsonProperty(value = "properties.configFilePath")
    private String configFilePath;

    /**
     * Get the enabled property: The enabled property.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The enabled property.
     *
     * @param enabled the enabled value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the runtimeVersion property: The runtimeVersion property.
     *
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: The runtimeVersion property.
     *
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the configFilePath property: The configFilePath property.
     *
     * @return the configFilePath value.
     */
    public String configFilePath() {
        return this.configFilePath;
    }

    /**
     * Set the configFilePath property: The configFilePath property.
     *
     * @param configFilePath the configFilePath value to set.
     * @return the AuthPlatform object itself.
     */
    public AuthPlatform withConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AuthPlatform withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
