// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AzureActiveDirectory model. */
@JsonFlatten
@Fluent
public class AzureActiveDirectory extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AzureActiveDirectory.class);

    /*
     * The enabled property.
     */
    @JsonProperty(value = "properties.enabled")
    private Boolean enabled;

    /*
     * The registration property.
     */
    @JsonProperty(value = "properties.registration")
    private AzureActiveDirectoryRegistration registration;

    /*
     * The login property.
     */
    @JsonProperty(value = "properties.login")
    private AzureActiveDirectoryLogin login;

    /*
     * The validation property.
     */
    @JsonProperty(value = "properties.validation")
    private AzureActiveDirectoryValidation validation;

    /*
     * The isAutoProvisioned property.
     */
    @JsonProperty(value = "properties.isAutoProvisioned")
    private Boolean isAutoProvisioned;

    /**
     * Get the enabled property: The enabled property.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The enabled property.
     *
     * @param enabled the enabled value to set.
     * @return the AzureActiveDirectory object itself.
     */
    public AzureActiveDirectory withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The registration property.
     *
     * @return the registration value.
     */
    public AzureActiveDirectoryRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The registration property.
     *
     * @param registration the registration value to set.
     * @return the AzureActiveDirectory object itself.
     */
    public AzureActiveDirectory withRegistration(AzureActiveDirectoryRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Get the login property: The login property.
     *
     * @return the login value.
     */
    public AzureActiveDirectoryLogin login() {
        return this.login;
    }

    /**
     * Set the login property: The login property.
     *
     * @param login the login value to set.
     * @return the AzureActiveDirectory object itself.
     */
    public AzureActiveDirectory withLogin(AzureActiveDirectoryLogin login) {
        this.login = login;
        return this;
    }

    /**
     * Get the validation property: The validation property.
     *
     * @return the validation value.
     */
    public AzureActiveDirectoryValidation validation() {
        return this.validation;
    }

    /**
     * Set the validation property: The validation property.
     *
     * @param validation the validation value to set.
     * @return the AzureActiveDirectory object itself.
     */
    public AzureActiveDirectory withValidation(AzureActiveDirectoryValidation validation) {
        this.validation = validation;
        return this;
    }

    /**
     * Get the isAutoProvisioned property: The isAutoProvisioned property.
     *
     * @return the isAutoProvisioned value.
     */
    public Boolean isAutoProvisioned() {
        return this.isAutoProvisioned;
    }

    /**
     * Set the isAutoProvisioned property: The isAutoProvisioned property.
     *
     * @param isAutoProvisioned the isAutoProvisioned value to set.
     * @return the AzureActiveDirectory object itself.
     */
    public AzureActiveDirectory withIsAutoProvisioned(Boolean isAutoProvisioned) {
        this.isAutoProvisioned = isAutoProvisioned;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AzureActiveDirectory withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (registration() != null) {
            registration().validate();
        }
        if (login() != null) {
            login().validate();
        }
        if (validation() != null) {
            validation().validate();
        }
    }
}
