// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AzureStaticWebAppsRegistration model. */
@JsonFlatten
@Fluent
public class AzureStaticWebAppsRegistration extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AzureStaticWebAppsRegistration.class);

    /*
     * The clientId property.
     */
    @JsonProperty(value = "properties.clientId")
    private String clientId;

    /**
     * Get the clientId property: The clientId property.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The clientId property.
     *
     * @param clientId the clientId value to set.
     * @return the AzureStaticWebAppsRegistration object itself.
     */
    public AzureStaticWebAppsRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AzureStaticWebAppsRegistration withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
