// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The GlobalValidation model. */
@JsonFlatten
@Fluent
public class GlobalValidation extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GlobalValidation.class);

    /*
     * The requireAuthentication property.
     */
    @JsonProperty(value = "properties.requireAuthentication")
    private Boolean requireAuthentication;

    /*
     * The unauthenticatedClientAction property.
     */
    @JsonProperty(value = "properties.unauthenticatedClientAction")
    private UnauthenticatedClientActionV2 unauthenticatedClientAction;

    /*
     * The redirectToProvider property.
     */
    @JsonProperty(value = "properties.redirectToProvider")
    private String redirectToProvider;

    /*
     * The excludedPaths property.
     */
    @JsonProperty(value = "properties.excludedPaths")
    private List<String> excludedPaths;

    /**
     * Get the requireAuthentication property: The requireAuthentication property.
     *
     * @return the requireAuthentication value.
     */
    public Boolean requireAuthentication() {
        return this.requireAuthentication;
    }

    /**
     * Set the requireAuthentication property: The requireAuthentication property.
     *
     * @param requireAuthentication the requireAuthentication value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withRequireAuthentication(Boolean requireAuthentication) {
        this.requireAuthentication = requireAuthentication;
        return this;
    }

    /**
     * Get the unauthenticatedClientAction property: The unauthenticatedClientAction property.
     *
     * @return the unauthenticatedClientAction value.
     */
    public UnauthenticatedClientActionV2 unauthenticatedClientAction() {
        return this.unauthenticatedClientAction;
    }

    /**
     * Set the unauthenticatedClientAction property: The unauthenticatedClientAction property.
     *
     * @param unauthenticatedClientAction the unauthenticatedClientAction value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withUnauthenticatedClientAction(UnauthenticatedClientActionV2 unauthenticatedClientAction) {
        this.unauthenticatedClientAction = unauthenticatedClientAction;
        return this;
    }

    /**
     * Get the redirectToProvider property: The redirectToProvider property.
     *
     * @return the redirectToProvider value.
     */
    public String redirectToProvider() {
        return this.redirectToProvider;
    }

    /**
     * Set the redirectToProvider property: The redirectToProvider property.
     *
     * @param redirectToProvider the redirectToProvider value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withRedirectToProvider(String redirectToProvider) {
        this.redirectToProvider = redirectToProvider;
        return this;
    }

    /**
     * Get the excludedPaths property: The excludedPaths property.
     *
     * @return the excludedPaths value.
     */
    public List<String> excludedPaths() {
        return this.excludedPaths;
    }

    /**
     * Set the excludedPaths property: The excludedPaths property.
     *
     * @param excludedPaths the excludedPaths value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public GlobalValidation withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
