// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The HttpSettings model. */
@JsonFlatten
@Fluent
public class HttpSettings extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HttpSettings.class);

    /*
     * The requireHttps property.
     */
    @JsonProperty(value = "properties.requireHttps")
    private Boolean requireHttps;

    /*
     * The routes property.
     */
    @JsonProperty(value = "properties.routes")
    private HttpSettingsRoutes routes;

    /*
     * The forwardProxy property.
     */
    @JsonProperty(value = "properties.forwardProxy")
    private ForwardProxy forwardProxy;

    /**
     * Get the requireHttps property: The requireHttps property.
     *
     * @return the requireHttps value.
     */
    public Boolean requireHttps() {
        return this.requireHttps;
    }

    /**
     * Set the requireHttps property: The requireHttps property.
     *
     * @param requireHttps the requireHttps value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withRequireHttps(Boolean requireHttps) {
        this.requireHttps = requireHttps;
        return this;
    }

    /**
     * Get the routes property: The routes property.
     *
     * @return the routes value.
     */
    public HttpSettingsRoutes routes() {
        return this.routes;
    }

    /**
     * Set the routes property: The routes property.
     *
     * @param routes the routes value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withRoutes(HttpSettingsRoutes routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the forwardProxy property: The forwardProxy property.
     *
     * @return the forwardProxy value.
     */
    public ForwardProxy forwardProxy() {
        return this.forwardProxy;
    }

    /**
     * Set the forwardProxy property: The forwardProxy property.
     *
     * @param forwardProxy the forwardProxy value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withForwardProxy(ForwardProxy forwardProxy) {
        this.forwardProxy = forwardProxy;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HttpSettings withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (routes() != null) {
            routes().validate();
        }
        if (forwardProxy() != null) {
            forwardProxy().validate();
        }
    }
}
