// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The HttpSettingsRoutes model. */
@JsonFlatten
@Fluent
public class HttpSettingsRoutes extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HttpSettingsRoutes.class);

    /*
     * The apiPrefix property.
     */
    @JsonProperty(value = "properties.apiPrefix")
    private String apiPrefix;

    /**
     * Get the apiPrefix property: The apiPrefix property.
     *
     * @return the apiPrefix value.
     */
    public String apiPrefix() {
        return this.apiPrefix;
    }

    /**
     * Set the apiPrefix property: The apiPrefix property.
     *
     * @param apiPrefix the apiPrefix value to set.
     * @return the HttpSettingsRoutes object itself.
     */
    public HttpSettingsRoutes withApiPrefix(String apiPrefix) {
        this.apiPrefix = apiPrefix;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HttpSettingsRoutes withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
