// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The LoginScopes model. */
@JsonFlatten
@Fluent
public class LoginScopes extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LoginScopes.class);

    /*
     * The scopes property.
     */
    @JsonProperty(value = "properties.scopes")
    private List<String> scopes;

    /**
     * Get the scopes property: The scopes property.
     *
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: The scopes property.
     *
     * @param scopes the scopes value to set.
     * @return the LoginScopes object itself.
     */
    public LoginScopes withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LoginScopes withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
