// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** MySQL migration request. */
@JsonFlatten
@Fluent
public class MigrateMySqlRequest extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MigrateMySqlRequest.class);

    /*
     * Connection string to the remote MySQL database.
     */
    @JsonProperty(value = "properties.connectionString")
    private String connectionString;

    /*
     * The type of migration operation to be done
     */
    @JsonProperty(value = "properties.migrationType")
    private MySqlMigrationType migrationType;

    /**
     * Get the connectionString property: Connection string to the remote MySQL database.
     *
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Connection string to the remote MySQL database.
     *
     * @param connectionString the connectionString value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the migrationType property: The type of migration operation to be done.
     *
     * @return the migrationType value.
     */
    public MySqlMigrationType migrationType() {
        return this.migrationType;
    }

    /**
     * Set the migrationType property: The type of migration operation to be done.
     *
     * @param migrationType the migrationType value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withMigrationType(MySqlMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MigrateMySqlRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
