// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Nonce model. */
@JsonFlatten
@Fluent
public class Nonce extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Nonce.class);

    /*
     * The validateNonce property.
     */
    @JsonProperty(value = "properties.validateNonce")
    private Boolean validateNonce;

    /*
     * The nonceExpirationInterval property.
     */
    @JsonProperty(value = "properties.nonceExpirationInterval")
    private String nonceExpirationInterval;

    /**
     * Get the validateNonce property: The validateNonce property.
     *
     * @return the validateNonce value.
     */
    public Boolean validateNonce() {
        return this.validateNonce;
    }

    /**
     * Set the validateNonce property: The validateNonce property.
     *
     * @param validateNonce the validateNonce value to set.
     * @return the Nonce object itself.
     */
    public Nonce withValidateNonce(Boolean validateNonce) {
        this.validateNonce = validateNonce;
        return this;
    }

    /**
     * Get the nonceExpirationInterval property: The nonceExpirationInterval property.
     *
     * @return the nonceExpirationInterval value.
     */
    public String nonceExpirationInterval() {
        return this.nonceExpirationInterval;
    }

    /**
     * Set the nonceExpirationInterval property: The nonceExpirationInterval property.
     *
     * @param nonceExpirationInterval the nonceExpirationInterval value to set.
     * @return the Nonce object itself.
     */
    public Nonce withNonceExpirationInterval(String nonceExpirationInterval) {
        this.nonceExpirationInterval = nonceExpirationInterval;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public Nonce withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
