// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The OpenIdConnectLogin model. */
@JsonFlatten
@Fluent
public class OpenIdConnectLogin extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(OpenIdConnectLogin.class);

    /*
     * The nameClaimType property.
     */
    @JsonProperty(value = "properties.nameClaimType")
    private String nameClaimType;

    /*
     * The scopes property.
     */
    @JsonProperty(value = "properties.scopes")
    private List<String> scopes;

    /**
     * Get the nameClaimType property: The nameClaimType property.
     *
     * @return the nameClaimType value.
     */
    public String nameClaimType() {
        return this.nameClaimType;
    }

    /**
     * Set the nameClaimType property: The nameClaimType property.
     *
     * @param nameClaimType the nameClaimType value to set.
     * @return the OpenIdConnectLogin object itself.
     */
    public OpenIdConnectLogin withNameClaimType(String nameClaimType) {
        this.nameClaimType = nameClaimType;
        return this;
    }

    /**
     * Get the scopes property: The scopes property.
     *
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: The scopes property.
     *
     * @param scopes the scopes value to set.
     * @return the OpenIdConnectLogin object itself.
     */
    public OpenIdConnectLogin withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OpenIdConnectLogin withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
