// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The OpenIdConnectRegistration model. */
@JsonFlatten
@Fluent
public class OpenIdConnectRegistration extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(OpenIdConnectRegistration.class);

    /*
     * The clientId property.
     */
    @JsonProperty(value = "properties.clientId")
    private String clientId;

    /*
     * The clientCredential property.
     */
    @JsonProperty(value = "properties.clientCredential")
    private OpenIdConnectClientCredential clientCredential;

    /*
     * The openIdConnectConfiguration property.
     */
    @JsonProperty(value = "properties.openIdConnectConfiguration")
    private OpenIdConnectConfig openIdConnectConfiguration;

    /**
     * Get the clientId property: The clientId property.
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The clientId property.
     *
     * @param clientId the clientId value to set.
     * @return the OpenIdConnectRegistration object itself.
     */
    public OpenIdConnectRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientCredential property: The clientCredential property.
     *
     * @return the clientCredential value.
     */
    public OpenIdConnectClientCredential clientCredential() {
        return this.clientCredential;
    }

    /**
     * Set the clientCredential property: The clientCredential property.
     *
     * @param clientCredential the clientCredential value to set.
     * @return the OpenIdConnectRegistration object itself.
     */
    public OpenIdConnectRegistration withClientCredential(OpenIdConnectClientCredential clientCredential) {
        this.clientCredential = clientCredential;
        return this;
    }

    /**
     * Get the openIdConnectConfiguration property: The openIdConnectConfiguration property.
     *
     * @return the openIdConnectConfiguration value.
     */
    public OpenIdConnectConfig openIdConnectConfiguration() {
        return this.openIdConnectConfiguration;
    }

    /**
     * Set the openIdConnectConfiguration property: The openIdConnectConfiguration property.
     *
     * @param openIdConnectConfiguration the openIdConnectConfiguration value to set.
     * @return the OpenIdConnectRegistration object itself.
     */
    public OpenIdConnectRegistration withOpenIdConnectConfiguration(OpenIdConnectConfig openIdConnectConfiguration) {
        this.openIdConnectConfiguration = openIdConnectConfiguration;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public OpenIdConnectRegistration withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (clientCredential() != null) {
            clientCredential().validate();
        }
        if (openIdConnectConfiguration() != null) {
            openIdConnectConfiguration().validate();
        }
    }
}
