// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static Site Custom Domain Request Properties ARM resource. */
@JsonFlatten
@Fluent
public class StaticSiteCustomDomainRequestPropertiesArmResource extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSiteCustomDomainRequestPropertiesArmResource.class);

    /*
     * Validation method for adding a custom domain
     */
    @JsonProperty(value = "properties.validationMethod")
    private String validationMethod;

    /**
     * Get the validationMethod property: Validation method for adding a custom domain.
     *
     * @return the validationMethod value.
     */
    public String validationMethod() {
        return this.validationMethod;
    }

    /**
     * Set the validationMethod property: Validation method for adding a custom domain.
     *
     * @param validationMethod the validationMethod value to set.
     * @return the StaticSiteCustomDomainRequestPropertiesArmResource object itself.
     */
    public StaticSiteCustomDomainRequestPropertiesArmResource withValidationMethod(String validationMethod) {
        this.validationMethod = validationMethod;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteCustomDomainRequestPropertiesArmResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
