/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class CertificateInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CertificateInner.class);
    @JsonProperty(value="properties.friendlyName", access=JsonProperty.Access.WRITE_ONLY)
    private String friendlyName;
    @JsonProperty(value="properties.subjectName", access=JsonProperty.Access.WRITE_ONLY)
    private String subjectName;
    @JsonProperty(value="properties.hostNames")
    private List<String> hostNames;
    @JsonProperty(value="properties.pfxBlob")
    private byte[] pfxBlob;
    @JsonProperty(value="properties.siteName", access=JsonProperty.Access.WRITE_ONLY)
    private String siteName;
    @JsonProperty(value="properties.selfLink", access=JsonProperty.Access.WRITE_ONLY)
    private String selfLink;
    @JsonProperty(value="properties.issuer", access=JsonProperty.Access.WRITE_ONLY)
    private String issuer;
    @JsonProperty(value="properties.issueDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime issueDate;
    @JsonProperty(value="properties.expirationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expirationDate;
    @JsonProperty(value="properties.password")
    private String password;
    @JsonProperty(value="properties.thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;
    @JsonProperty(value="properties.valid", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean valid;
    @JsonProperty(value="properties.cerBlob", access=JsonProperty.Access.WRITE_ONLY)
    private byte[] cerBlob;
    @JsonProperty(value="properties.publicKeyHash", access=JsonProperty.Access.WRITE_ONLY)
    private String publicKeyHash;
    @JsonProperty(value="properties.hostingEnvironmentProfile", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    @JsonProperty(value="properties.keyVaultId")
    private String keyVaultId;
    @JsonProperty(value="properties.keyVaultSecretName")
    private String keyVaultSecretName;
    @JsonProperty(value="properties.keyVaultSecretStatus", access=JsonProperty.Access.WRITE_ONLY)
    private KeyVaultSecretStatus keyVaultSecretStatus;
    @JsonProperty(value="properties.serverFarmId")
    private String serverFarmId;
    @JsonProperty(value="properties.canonicalName")
    private String canonicalName;
    @JsonProperty(value="properties.domainValidationMethod")
    private String domainValidationMethod;
    @JsonProperty(value="kind")
    private String kind;

    public String friendlyName() {
        return this.friendlyName;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public CertificateInner withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public byte[] pfxBlob() {
        return CoreUtils.clone((byte[])this.pfxBlob);
    }

    public CertificateInner withPfxBlob(byte[] pfxBlob) {
        this.pfxBlob = CoreUtils.clone((byte[])pfxBlob);
        return this;
    }

    public String siteName() {
        return this.siteName;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String password() {
        return this.password;
    }

    public CertificateInner withPassword(String password) {
        this.password = password;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public byte[] cerBlob() {
        return CoreUtils.clone((byte[])this.cerBlob);
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public String keyVaultId() {
        return this.keyVaultId;
    }

    public CertificateInner withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    public CertificateInner withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.keyVaultSecretStatus;
    }

    public String serverFarmId() {
        return this.serverFarmId;
    }

    public CertificateInner withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public CertificateInner withCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    public String domainValidationMethod() {
        return this.domainValidationMethod;
    }

    public CertificateInner withDomainValidationMethod(String domainValidationMethod) {
        this.domainValidationMethod = domainValidationMethod;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public CertificateInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public CertificateInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CertificateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
    }
}

