/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.FunctionAppBasicImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionAppImpl;
import com.azure.resourcemanager.appservice.implementation.FunctionEnvelopeImpl;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import com.azure.resourcemanager.appservice.models.FunctionAppBasic;
import com.azure.resourcemanager.appservice.models.FunctionApps;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.SupportsBatchDeletion;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.BatchDeletionImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FunctionAppsImpl
extends GroupableResourcesImpl<FunctionApp, FunctionAppImpl, SiteInner, WebAppsClient, AppServiceManager>
implements FunctionApps,
SupportsBatchDeletion {
    public FunctionAppsImpl(AppServiceManager manager) {
        super((Object)((WebSiteManagementClient)manager.serviceClient()).getWebApps(), (Manager)manager);
    }

    public FunctionApp getByResourceGroup(String groupName, String name) {
        SiteInner siteInner = ((WebAppsClient)this.inner()).getByResourceGroup(groupName, name);
        if (siteInner == null) {
            return null;
        }
        return this.wrapModel(siteInner, ((WebAppsClient)this.inner()).getConfiguration(groupName, name), ((WebAppsClient)this.inner()).getDiagnosticLogsConfiguration(groupName, name));
    }

    public Mono<FunctionApp> getByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return this.getInnerAsync(resourceGroupName, name).flatMap(siteInner -> Mono.zip(((WebAppsClient)this.inner()).getConfigurationAsync(resourceGroupName, name), ((WebAppsClient)this.inner()).getDiagnosticLogsConfigurationAsync(resourceGroupName, name), (siteConfigResourceInner, logsConfigInner) -> this.wrapModel((SiteInner)((Object)siteInner), (SiteConfigResourceInner)((Object)((Object)siteConfigResourceInner)), (SiteLogsConfigInner)((Object)((Object)logsConfigInner)))));
    }

    protected Mono<SiteInner> getInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    public PagedIterable<FunctionEnvelope> listFunctions(String resourceGroupName, String name) {
        return PagedConverter.mapPage(((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getWebApps().listFunctions(resourceGroupName, name), FunctionEnvelopeImpl::new);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    protected FunctionAppImpl wrapModel(String name) {
        return new FunctionAppImpl(name, new SiteInner().withKind("functionapp"), null, null, (AppServiceManager)this.manager());
    }

    protected FunctionAppImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null, null);
    }

    private FunctionAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new FunctionAppImpl(inner.name(), inner, siteConfig, logConfig, (AppServiceManager)this.manager());
    }

    public FunctionAppImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<Void> deleteByResourceGroupAsync(String resourceGroupName, String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter 'name' is required and cannot be null."));
        }
        return ((WebAppsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    public Flux<String> deleteByIdsAsync(Collection<String> ids) {
        return BatchDeletionImpl.deleteByIdsAsync(ids, this::deleteInnerAsync);
    }

    public Flux<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).blockLast();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public PagedIterable<FunctionAppBasic> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<FunctionAppBasic> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return new PagedFlux(() -> Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listByResourceGroupAsync(resourceGroupName), inner -> FunctionAppsImpl.isFunctionApp(inner) ? Mono.just((Object)new FunctionAppBasicImpl((SiteInner)((Object)inner), (AppServiceManager)this.manager())) : Mono.empty());
    }

    public PagedIterable<FunctionAppBasic> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<FunctionAppBasic> listAsync() {
        return PagedConverter.flatMapPage(((WebAppsClient)this.inner()).listAsync(), inner -> FunctionAppsImpl.isFunctionApp(inner) ? Mono.just((Object)new FunctionAppBasicImpl((SiteInner)((Object)inner), (AppServiceManager)this.manager())) : Mono.empty());
    }

    private static boolean isFunctionApp(SiteInner inner) {
        return inner.kind() != null && Arrays.asList(inner.kind().split(",")).contains("functionapp");
    }
}

