/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.GlobalsClient;
import com.azure.resourcemanager.appservice.fluent.models.DeletedSiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import java.util.List;
import reactor.core.publisher.Mono;

public final class GlobalsClientImpl
implements GlobalsClient {
    private final ClientLogger logger = new ClientLogger(GlobalsClientImpl.class);
    private final GlobalsService service;
    private final WebSiteManagementClientImpl client;

    GlobalsClientImpl(WebSiteManagementClientImpl client) {
        this.service = (GlobalsService)RestProxy.create(GlobalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<DeletedSiteInner>> getDeletedWebAppWithResponseAsync(String deletedSiteId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deletedSiteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedSiteId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedWebApp(this.client.getEndpoint(), deletedSiteId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<DeletedSiteInner>> getDeletedWebAppWithResponseAsync(String deletedSiteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deletedSiteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedSiteId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDeletedWebApp(this.client.getEndpoint(), deletedSiteId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<DeletedSiteInner> getDeletedWebAppAsync(String deletedSiteId) {
        return this.getDeletedWebAppWithResponseAsync(deletedSiteId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeletedSiteInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public DeletedSiteInner getDeletedWebApp(String deletedSiteId) {
        return (DeletedSiteInner)((Object)this.getDeletedWebAppAsync(deletedSiteId).block());
    }

    @Override
    public Response<DeletedSiteInner> getDeletedWebAppWithResponse(String deletedSiteId, Context context) {
        return (Response)this.getDeletedWebAppWithResponseAsync(deletedSiteId, context).block();
    }

    @Override
    public Mono<Response<List<SnapshotInner>>> getDeletedWebAppSnapshotsWithResponseAsync(String deletedSiteId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deletedSiteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedSiteId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedWebAppSnapshots(this.client.getEndpoint(), deletedSiteId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<List<SnapshotInner>>> getDeletedWebAppSnapshotsWithResponseAsync(String deletedSiteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deletedSiteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deletedSiteId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDeletedWebAppSnapshots(this.client.getEndpoint(), deletedSiteId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<List<SnapshotInner>> getDeletedWebAppSnapshotsAsync(String deletedSiteId) {
        return this.getDeletedWebAppSnapshotsWithResponseAsync(deletedSiteId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<SnapshotInner> getDeletedWebAppSnapshots(String deletedSiteId) {
        return (List)this.getDeletedWebAppSnapshotsAsync(deletedSiteId).block();
    }

    @Override
    public Response<List<SnapshotInner>> getDeletedWebAppSnapshotsWithResponse(String deletedSiteId, Context context) {
        return (Response)this.getDeletedWebAppSnapshotsWithResponseAsync(deletedSiteId, context).block();
    }

    @Override
    public Mono<Response<Void>> getSubscriptionOperationWithAsyncResponseWithResponseAsync(String location, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSubscriptionOperationWithAsyncResponse(this.client.getEndpoint(), location, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> getSubscriptionOperationWithAsyncResponseWithResponseAsync(String location, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSubscriptionOperationWithAsyncResponse(this.client.getEndpoint(), location, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> getSubscriptionOperationWithAsyncResponseAsync(String location, String operationId) {
        return this.getSubscriptionOperationWithAsyncResponseWithResponseAsync(location, operationId).flatMap(res -> Mono.empty());
    }

    @Override
    public void getSubscriptionOperationWithAsyncResponse(String location, String operationId) {
        this.getSubscriptionOperationWithAsyncResponseAsync(location, operationId).block();
    }

    @Override
    public Response<Void> getSubscriptionOperationWithAsyncResponseWithResponse(String location, String operationId, Context context) {
        return (Response)this.getSubscriptionOperationWithAsyncResponseWithResponseAsync(location, operationId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface GlobalsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<DeletedSiteInner>> getDeletedWebApp(@HostParam(value="$host") String var1, @PathParam(value="deletedSiteId") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}/snapshots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<List<SnapshotInner>>> getDeletedWebAppSnapshots(@HostParam(value="$host") String var1, @PathParam(value="deletedSiteId") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/operations/{operationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> getSubscriptionOperationWithAsyncResponse(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="operationId") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

