/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.RecommendationsClient;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationInner;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationRuleInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.RecommendationCollection;
import reactor.core.publisher.Mono;

public final class RecommendationsClientImpl
implements RecommendationsClient {
    private final ClientLogger logger = new ClientLogger(RecommendationsClientImpl.class);
    private final RecommendationsService service;
    private final WebSiteManagementClientImpl client;

    RecommendationsClientImpl(WebSiteManagementClientImpl client) {
        this.service = (RecommendationsService)RestProxy.create(RecommendationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<RecommendationInner>> listSinglePageAsync(Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listSinglePageAsync(Boolean featured, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RecommendationInner> listAsync(Boolean featured, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(featured, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RecommendationInner> listAsync() {
        Boolean featured = null;
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(featured, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RecommendationInner> listAsync(Boolean featured, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(featured, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RecommendationInner> list() {
        Boolean featured = null;
        String filter = null;
        return new PagedIterable(this.listAsync(featured, filter));
    }

    @Override
    public PagedIterable<RecommendationInner> list(Boolean featured, String filter, Context context) {
        return new PagedIterable(this.listAsync(featured, filter, context));
    }

    @Override
    public Mono<Response<Void>> resetAllFiltersWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetAllFilters(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> resetAllFiltersWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetAllFilters(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> resetAllFiltersAsync() {
        return this.resetAllFiltersWithResponseAsync().flatMap(res -> Mono.empty());
    }

    @Override
    public void resetAllFilters() {
        this.resetAllFiltersAsync().block();
    }

    @Override
    public Response<Void> resetAllFiltersWithResponse(Context context) {
        return (Response)this.resetAllFiltersWithResponseAsync(context).block();
    }

    @Override
    public Mono<Response<Void>> disableRecommendationForSubscriptionWithResponseAsync(String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableRecommendationForSubscription(this.client.getEndpoint(), name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> disableRecommendationForSubscriptionWithResponseAsync(String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableRecommendationForSubscription(this.client.getEndpoint(), name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> disableRecommendationForSubscriptionAsync(String name) {
        return this.disableRecommendationForSubscriptionWithResponseAsync(name).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableRecommendationForSubscription(String name) {
        this.disableRecommendationForSubscriptionAsync(name).block();
    }

    @Override
    public Response<Void> disableRecommendationForSubscriptionWithResponse(String name, Context context) {
        return (Response)this.disableRecommendationForSubscriptionWithResponseAsync(name, context).block();
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHistoryForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, expiredOnly, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHistoryForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, expiredOnly, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        return new PagedFlux(() -> this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter), nextLink -> this.listHistoryForHostingEnvironmentNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName) {
        Boolean expiredOnly = null;
        String filter = null;
        return new PagedFlux(() -> this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter), nextLink -> this.listHistoryForHostingEnvironmentNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        return new PagedFlux(() -> this.listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter, context), nextLink -> this.listHistoryForHostingEnvironmentNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName) {
        Boolean expiredOnly = null;
        String filter = null;
        return new PagedIterable(this.listHistoryForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter));
    }

    @Override
    public PagedIterable<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        return new PagedIterable(this.listHistoryForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter, context));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRecommendedRulesForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRecommendedRulesForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        return new PagedFlux(() -> this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter), nextLink -> this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName) {
        Boolean featured = null;
        String filter = null;
        return new PagedFlux(() -> this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter), nextLink -> this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        return new PagedFlux(() -> this.listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName, featured, filter, context), nextLink -> this.listRecommendedRulesForHostingEnvironmentNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName) {
        Boolean featured = null;
        String filter = null;
        return new PagedIterable(this.listRecommendedRulesForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, featured, filter));
    }

    @Override
    public PagedIterable<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        return new PagedIterable(this.listRecommendedRulesForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, featured, filter, context));
    }

    @Override
    public Mono<Response<Void>> disableAllForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableAllForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> disableAllForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableAllForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> disableAllForHostingEnvironmentAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        return this.disableAllForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, hostingEnvironmentName).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableAllForHostingEnvironment(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        this.disableAllForHostingEnvironmentAsync(resourceGroupName, environmentName, hostingEnvironmentName).block();
    }

    @Override
    public Response<Void> disableAllForHostingEnvironmentWithResponse(String resourceGroupName, String environmentName, String hostingEnvironmentName, Context context) {
        return (Response)this.disableAllForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, hostingEnvironmentName, context).block();
    }

    @Override
    public Mono<Response<Void>> resetAllFiltersForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetAllFiltersForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> resetAllFiltersForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetAllFiltersForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> resetAllFiltersForHostingEnvironmentAsync(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        return this.resetAllFiltersForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, hostingEnvironmentName).flatMap(res -> Mono.empty());
    }

    @Override
    public void resetAllFiltersForHostingEnvironment(String resourceGroupName, String environmentName, String hostingEnvironmentName) {
        this.resetAllFiltersForHostingEnvironmentAsync(resourceGroupName, environmentName, hostingEnvironmentName).block();
    }

    @Override
    public Response<Void> resetAllFiltersForHostingEnvironmentWithResponse(String resourceGroupName, String environmentName, String hostingEnvironmentName, Context context) {
        return (Response)this.resetAllFiltersForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, hostingEnvironmentName, context).block();
    }

    @Override
    public Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithResponseAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRuleDetailsByHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithResponseAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRuleDetailsByHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId) {
        return this.getRuleDetailsByHostingEnvironmentWithResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecommendationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName, String hostingEnvironmentName, String name) {
        Boolean updateSeen = null;
        String recommendationId = null;
        return this.getRuleDetailsByHostingEnvironmentWithResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecommendationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RecommendationRuleInner getRuleDetailsByHostingEnvironment(String resourceGroupName, String hostingEnvironmentName, String name) {
        Boolean updateSeen = null;
        String recommendationId = null;
        return (RecommendationRuleInner)((Object)this.getRuleDetailsByHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId).block());
    }

    @Override
    public Response<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentWithResponse(String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId, Context context) {
        return (Response)this.getRuleDetailsByHostingEnvironmentWithResponseAsync(resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId, context).block();
    }

    @Override
    public Mono<Response<Void>> disableRecommendationForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String name, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableRecommendationForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, name, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> disableRecommendationForHostingEnvironmentWithResponseAsync(String resourceGroupName, String environmentName, String name, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableRecommendationForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName, name, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> disableRecommendationForHostingEnvironmentAsync(String resourceGroupName, String environmentName, String name, String hostingEnvironmentName) {
        return this.disableRecommendationForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, name, hostingEnvironmentName).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableRecommendationForHostingEnvironment(String resourceGroupName, String environmentName, String name, String hostingEnvironmentName) {
        this.disableRecommendationForHostingEnvironmentAsync(resourceGroupName, environmentName, name, hostingEnvironmentName).block();
    }

    @Override
    public Response<Void> disableRecommendationForHostingEnvironmentWithResponse(String resourceGroupName, String environmentName, String name, String hostingEnvironmentName, Context context) {
        return (Response)this.disableRecommendationForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, name, hostingEnvironmentName, context).block();
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHistoryForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, expiredOnly, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHistoryForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, expiredOnly, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter) {
        return new PagedFlux(() -> this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter), nextLink -> this.listHistoryForWebAppNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName) {
        Boolean expiredOnly = null;
        String filter = null;
        return new PagedFlux(() -> this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter), nextLink -> this.listHistoryForWebAppNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName, Boolean expiredOnly, String filter, Context context) {
        return new PagedFlux(() -> this.listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter, context), nextLink -> this.listHistoryForWebAppNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName) {
        Boolean expiredOnly = null;
        String filter = null;
        return new PagedIterable(this.listHistoryForWebAppAsync(resourceGroupName, siteName, expiredOnly, filter));
    }

    @Override
    public PagedIterable<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName, Boolean expiredOnly, String filter, Context context) {
        return new PagedIterable(this.listHistoryForWebAppAsync(resourceGroupName, siteName, expiredOnly, filter, context));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRecommendedRulesForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppSinglePageAsync(String resourceGroupName, String siteName, Boolean featured, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRecommendedRulesForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, featured, filter, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        return new PagedFlux(() -> this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter), nextLink -> this.listRecommendedRulesForWebAppNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName) {
        Boolean featured = null;
        String filter = null;
        return new PagedFlux(() -> this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter), nextLink -> this.listRecommendedRulesForWebAppNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter, Context context) {
        return new PagedFlux(() -> this.listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter, context), nextLink -> this.listRecommendedRulesForWebAppNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName) {
        Boolean featured = null;
        String filter = null;
        return new PagedIterable(this.listRecommendedRulesForWebAppAsync(resourceGroupName, siteName, featured, filter));
    }

    @Override
    public PagedIterable<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName, Boolean featured, String filter, Context context) {
        return new PagedIterable(this.listRecommendedRulesForWebAppAsync(resourceGroupName, siteName, featured, filter, context));
    }

    @Override
    public Mono<Response<Void>> disableAllForWebAppWithResponseAsync(String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableAllForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> disableAllForWebAppWithResponseAsync(String resourceGroupName, String siteName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableAllForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName) {
        return this.disableAllForWebAppWithResponseAsync(resourceGroupName, siteName).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableAllForWebApp(String resourceGroupName, String siteName) {
        this.disableAllForWebAppAsync(resourceGroupName, siteName).block();
    }

    @Override
    public Response<Void> disableAllForWebAppWithResponse(String resourceGroupName, String siteName, Context context) {
        return (Response)this.disableAllForWebAppWithResponseAsync(resourceGroupName, siteName, context).block();
    }

    @Override
    public Mono<Response<Void>> resetAllFiltersForWebAppWithResponseAsync(String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetAllFiltersForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> resetAllFiltersForWebAppWithResponseAsync(String resourceGroupName, String siteName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetAllFiltersForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName) {
        return this.resetAllFiltersForWebAppWithResponseAsync(resourceGroupName, siteName).flatMap(res -> Mono.empty());
    }

    @Override
    public void resetAllFiltersForWebApp(String resourceGroupName, String siteName) {
        this.resetAllFiltersForWebAppAsync(resourceGroupName, siteName).block();
    }

    @Override
    public Response<Void> resetAllFiltersForWebAppWithResponse(String resourceGroupName, String siteName, Context context) {
        return (Response)this.resetAllFiltersForWebAppWithResponseAsync(resourceGroupName, siteName, context).block();
    }

    @Override
    public Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebAppWithResponseAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRuleDetailsByWebApp(this.client.getEndpoint(), resourceGroupName, siteName, name, updateSeen, recommendationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebAppWithResponseAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRuleDetailsByWebApp(this.client.getEndpoint(), resourceGroupName, siteName, name, updateSeen, recommendationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId) {
        return this.getRuleDetailsByWebAppWithResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecommendationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name) {
        Boolean updateSeen = null;
        String recommendationId = null;
        return this.getRuleDetailsByWebAppWithResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RecommendationRuleInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name) {
        Boolean updateSeen = null;
        String recommendationId = null;
        return (RecommendationRuleInner)((Object)this.getRuleDetailsByWebAppAsync(resourceGroupName, siteName, name, updateSeen, recommendationId).block());
    }

    @Override
    public Response<RecommendationRuleInner> getRuleDetailsByWebAppWithResponse(String resourceGroupName, String siteName, String name, Boolean updateSeen, String recommendationId, Context context) {
        return (Response)this.getRuleDetailsByWebAppWithResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId, context).block();
    }

    @Override
    public Mono<Response<Void>> disableRecommendationForSiteWithResponseAsync(String resourceGroupName, String siteName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableRecommendationForSite(this.client.getEndpoint(), resourceGroupName, siteName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> disableRecommendationForSiteWithResponseAsync(String resourceGroupName, String siteName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableRecommendationForSite(this.client.getEndpoint(), resourceGroupName, siteName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> disableRecommendationForSiteAsync(String resourceGroupName, String siteName, String name) {
        return this.disableRecommendationForSiteWithResponseAsync(resourceGroupName, siteName, name).flatMap(res -> Mono.empty());
    }

    @Override
    public void disableRecommendationForSite(String resourceGroupName, String siteName, String name) {
        this.disableRecommendationForSiteAsync(resourceGroupName, siteName, name).block();
    }

    @Override
    public Response<Void> disableRecommendationForSiteWithResponse(String resourceGroupName, String siteName, String name, Context context) {
        return (Response)this.disableRecommendationForSiteWithResponseAsync(resourceGroupName, siteName, name, context).block();
    }

    private Mono<PagedResponse<RecommendationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHistoryForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHistoryForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRecommendedRulesForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRecommendedRulesForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHistoryForWebAppNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHistoryForWebAppNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRecommendedRulesForWebAppNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRecommendedRulesForWebAppNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RecommendationCollection)res.getValue()).value(), ((RecommendationCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface RecommendationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="featured") Boolean var2, @QueryParam(value="$filter", encoded=true) String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resetAllFilters(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> disableRecommendationForSubscription(@HostParam(value="$host") String var1, @PathParam(value="name") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendationHistory")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listHistoryForHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="hostingEnvironmentName") String var3, @QueryParam(value="expiredOnly") Boolean var4, @QueryParam(value="$filter", encoded=true) String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listRecommendedRulesForHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="hostingEnvironmentName") String var3, @QueryParam(value="featured") Boolean var4, @QueryParam(value="$filter", encoded=true) String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/disable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> disableAllForHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="environmentName") String var3, @PathParam(value="hostingEnvironmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resetAllFiltersForHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="environmentName") String var3, @PathParam(value="hostingEnvironmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="hostingEnvironmentName") String var3, @PathParam(value="name") String var4, @QueryParam(value="updateSeen") Boolean var5, @QueryParam(value="recommendationId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}/disable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> disableRecommendationForHostingEnvironment(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="environmentName") String var3, @PathParam(value="name") String var4, @PathParam(value="hostingEnvironmentName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listHistoryForWebApp(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @QueryParam(value="expiredOnly") Boolean var4, @QueryParam(value="$filter", encoded=true) String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listRecommendedRulesForWebApp(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @QueryParam(value="featured") Boolean var4, @QueryParam(value="$filter", encoded=true) String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> disableAllForWebApp(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resetAllFiltersForWebApp(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebApp(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @PathParam(value="name") String var4, @QueryParam(value="updateSeen") Boolean var5, @QueryParam(value="recommendationId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> disableRecommendationForSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="siteName") String var3, @PathParam(value="name") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listHistoryForHostingEnvironmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listRecommendedRulesForHostingEnvironmentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listHistoryForWebAppNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RecommendationCollection>> listRecommendedRulesForWebAppNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

