/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.StaticSitesClient;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteBuildArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteFunctionOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationResponseResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserProvidedFunctionAppArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSitesWorkflowPreviewInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.StringListInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.PrivateEndpointConnectionCollection;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainRequestPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteFunctionOverviewCollection;
import com.azure.resourcemanager.appservice.models.StaticSitePatchResource;
import com.azure.resourcemanager.appservice.models.StaticSiteResetPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteUserInvitationRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionAppsCollection;
import com.azure.resourcemanager.appservice.models.StaticSiteZipDeploymentArmResource;
import com.azure.resourcemanager.appservice.models.StaticSitesWorkflowPreviewRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StaticSitesClientImpl
implements InnerSupportsGet<StaticSiteArmResourceInner>,
InnerSupportsListing<StaticSiteArmResourceInner>,
InnerSupportsDelete<Void>,
StaticSitesClient {
    private final ClientLogger logger = new ClientLogger(StaticSitesClientImpl.class);
    private final StaticSitesService service;
    private final WebSiteManagementClientImpl client;

    StaticSitesClientImpl(WebSiteManagementClientImpl client) {
        this.service = (StaticSitesService)RestProxy.create(StaticSitesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflowWithResponseAsync(String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSitesWorkflowPreviewRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSitesWorkflowPreviewRequest is required and cannot be null."));
        }
        staticSitesWorkflowPreviewRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.previewWorkflow(this.client.getEndpoint(), location, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSitesWorkflowPreviewRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflowWithResponseAsync(String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSitesWorkflowPreviewRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSitesWorkflowPreviewRequest is required and cannot be null."));
        }
        staticSitesWorkflowPreviewRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.previewWorkflow(this.client.getEndpoint(), location, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSitesWorkflowPreviewRequest, "application/json", context);
    }

    @Override
    public Mono<StaticSitesWorkflowPreviewInner> previewWorkflowAsync(String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        return this.previewWorkflowWithResponseAsync(location, staticSitesWorkflowPreviewRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSitesWorkflowPreviewInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSitesWorkflowPreviewInner previewWorkflow(String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest) {
        return (StaticSitesWorkflowPreviewInner)((Object)this.previewWorkflowAsync(location, staticSitesWorkflowPreviewRequest).block());
    }

    @Override
    public Response<StaticSitesWorkflowPreviewInner> previewWorkflowWithResponse(String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest, Context context) {
        return (Response)this.previewWorkflowWithResponseAsync(location, staticSitesWorkflowPreviewRequest, context).block();
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteArmResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteArmResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.getStaticSitesByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.getStaticSitesByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    public Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StaticSiteArmResourceInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteArmResourceInner getByResourceGroup(String resourceGroupName, String name) {
        return (StaticSiteArmResourceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StaticSiteArmResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSiteAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteArmResourceInner.class), (Type)((Object)StaticSiteArmResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSiteAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteArmResourceInner.class), (Type)((Object)StaticSiteArmResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context).getSyncPoller();
    }

    @Override
    public Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return this.beginCreateOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public StaticSiteArmResourceInner createOrUpdateStaticSite(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope) {
        return (StaticSiteArmResourceInner)((Object)this.createOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).block());
    }

    @Override
    public StaticSiteArmResourceInner createOrUpdateStaticSite(String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context) {
        return (StaticSiteArmResourceInner)((Object)this.createOrUpdateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, name);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, name, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name) {
        return this.beginDeleteAsync(resourceGroupName, name).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context) {
        return this.beginDeleteAsync(resourceGroupName, name, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String name) {
        return this.beginDeleteAsync(resourceGroupName, name).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String name, Context context) {
        return this.beginDeleteAsync(resourceGroupName, name, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String name) {
        this.deleteAsync(resourceGroupName, name).block();
    }

    @Override
    public void delete(String resourceGroupName, String name, Context context) {
        this.deleteAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteEnvelope is required and cannot be null."));
        }
        staticSiteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteEnvelope, "application/json", context);
    }

    @Override
    public Mono<StaticSiteArmResourceInner> updateStaticSiteAsync(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        return this.updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteArmResourceInner updateStaticSite(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope) {
        return (StaticSiteArmResourceInner)((Object)this.updateStaticSiteAsync(resourceGroupName, name, staticSiteEnvelope).block());
    }

    @Override
    public Response<StaticSiteArmResourceInner> updateStaticSiteWithResponse(String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope, Context context) {
        return (Response)this.updateStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersSinglePageAsync(String resourceGroupName, String name, String authprovider) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name, authprovider, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersSinglePageAsync(String resourceGroupName, String name, String authprovider, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteUsers(this.client.getEndpoint(), resourceGroupName, name, authprovider, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name, String authprovider) {
        return new PagedFlux(() -> this.listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider), nextLink -> this.listStaticSiteUsersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(String resourceGroupName, String name, String authprovider, Context context) {
        return new PagedFlux(() -> this.listStaticSiteUsersSinglePageAsync(resourceGroupName, name, authprovider, context), nextLink -> this.listStaticSiteUsersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name, String authprovider) {
        return new PagedIterable(this.listStaticSiteUsersAsync(resourceGroupName, name, authprovider));
    }

    @Override
    public PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(String resourceGroupName, String name, String authprovider, Context context) {
        return new PagedIterable(this.listStaticSiteUsersAsync(resourceGroupName, name, authprovider, context));
    }

    @Override
    public Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> deleteStaticSiteUserAsync(String resourceGroupName, String name, String authprovider, String userid) {
        return this.deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid) {
        this.deleteStaticSiteUserAsync(resourceGroupName, name, authprovider, userid).block();
    }

    @Override
    public Response<Void> deleteStaticSiteUserWithResponse(String resourceGroupName, String name, String authprovider, String userid, Context context) {
        return (Response)this.deleteStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, context).block();
    }

    @Override
    public Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        }
        staticSiteUserEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (authprovider == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter authprovider is required and cannot be null."));
        }
        if (userid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userid is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserEnvelope is required and cannot be null."));
        }
        staticSiteUserEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateStaticSiteUser(this.client.getEndpoint(), resourceGroupName, name, authprovider, userid, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserEnvelope, "application/json", context);
    }

    @Override
    public Mono<StaticSiteUserArmResourceInner> updateStaticSiteUserAsync(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return this.updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserArmResourceInner updateStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope) {
        return (StaticSiteUserArmResourceInner)((Object)this.updateStaticSiteUserAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope).block());
    }

    @Override
    public Response<StaticSiteUserArmResourceInner> updateStaticSiteUserWithResponse(String resourceGroupName, String name, String authprovider, String userid, StaticSiteUserArmResourceInner staticSiteUserEnvelope, Context context) {
        return (Response)this.updateStaticSiteUserWithResponseAsync(resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuilds(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getStaticSiteBuildsSinglePageAsync(resourceGroupName, name), nextLink -> this.getStaticSiteBuildsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getStaticSiteBuildsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getStaticSiteBuildsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name) {
        return new PagedIterable(this.getStaticSiteBuildsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getStaticSiteBuildsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StaticSiteBuildArmResourceInner> getStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName) {
        return this.getStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteBuildArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteBuildArmResourceInner getStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        return (StaticSiteBuildArmResourceInner)((Object)this.getStaticSiteBuildAsync(resourceGroupName, name, environmentName).block());
    }

    @Override
    public Response<StaticSiteBuildArmResourceInner> getStaticSiteBuildWithResponse(String resourceGroupName, String name, String environmentName, Context context) {
        return (Response)this.getStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(String resourceGroupName, String name, String environmentName, Context context) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, Context context) {
        return this.beginDeleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        this.deleteStaticSiteBuildAsync(resourceGroupName, name, environmentName).block();
    }

    @Override
    public void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName, Context context) {
        this.deleteStaticSiteBuildAsync(resourceGroupName, name, environmentName, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteBuildAppSettings(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteBuildAppSettingsAsync(resourceGroupName, name, environmentName, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsWithResponse(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, appSettings, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(resourceGroupName, name, environmentName, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponse(String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, appSettings, context).block();
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsSinglePageAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsSinglePageAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctions(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(String resourceGroupName, String name, String environmentName) {
        return new PagedFlux(() -> this.listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, environmentName), nextLink -> this.listStaticSiteBuildFunctionsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedFlux(() -> this.listStaticSiteBuildFunctionsSinglePageAsync(resourceGroupName, name, environmentName, context), nextLink -> this.listStaticSiteBuildFunctionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(String resourceGroupName, String name, String environmentName) {
        return new PagedIterable(this.listStaticSiteBuildFunctionsAsync(resourceGroupName, name, environmentName));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedIterable(this.listStaticSiteBuildFunctionsAsync(resourceGroupName, name, environmentName, context));
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteBuildAppSettingsAsync(String resourceGroupName, String name, String environmentName) {
        return this.listStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteBuildAppSettings(String resourceGroupName, String name, String environmentName) {
        return (StringDictionaryInner)((Object)this.listStaticSiteBuildAppSettingsAsync(resourceGroupName, name, environmentName).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteBuildAppSettingsWithResponse(String resourceGroupName, String name, String environmentName, Context context) {
        return (Response)this.listStaticSiteBuildAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsAsync(String resourceGroupName, String name, String environmentName) {
        return this.listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteBuildFunctionAppSettings(String resourceGroupName, String name, String environmentName) {
        return (StringDictionaryInner)((Object)this.listStaticSiteBuildFunctionAppSettingsAsync(resourceGroupName, name, environmentName).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsWithResponse(String resourceGroupName, String name, String environmentName, Context context) {
        return (Response)this.listStaticSiteBuildFunctionAppSettingsWithResponseAsync(resourceGroupName, name, environmentName, context).block();
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(String resourceGroupName, String name, String environmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppsForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(String resourceGroupName, String name, String environmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppsForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName) {
        return new PagedFlux(() -> this.getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(resourceGroupName, name, environmentName), nextLink -> this.getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedFlux(() -> this.getUserProvidedFunctionAppsForStaticSiteBuildSinglePageAsync(resourceGroupName, name, environmentName, context), nextLink -> this.getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuild(String resourceGroupName, String name, String environmentName) {
        return new PagedIterable(this.getUserProvidedFunctionAppsForStaticSiteBuildAsync(resourceGroupName, name, environmentName));
    }

    @Override
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuild(String resourceGroupName, String name, String environmentName, Context context) {
        return new PagedIterable(this.getUserProvidedFunctionAppsForStaticSiteBuildAsync(resourceGroupName, name, environmentName, context));
    }

    @Override
    public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName) {
        return this.getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner getUserProvidedFunctionAppForStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.getUserProvidedFunctionAppForStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName).block());
    }

    @Override
    public Response<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteBuildWithResponse(String resourceGroupName, String name, String environmentName, String functionAppName, Context context) {
        return (Response)this.getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        }
        staticSiteUserProvidedFunctionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.registerUserProvidedFunctionAppWithStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, isForced, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        }
        staticSiteUserProvidedFunctionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.registerUserProvidedFunctionAppWithStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, isForced, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).getSyncPoller();
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        Boolean isForced = null;
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).block());
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        Boolean isForced = null;
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).block());
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).block());
    }

    @Override
    public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detachUserProvidedFunctionAppFromStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.detachUserProvidedFunctionAppFromStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> detachUserProvidedFunctionAppFromStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, String functionAppName) {
        return this.detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName).flatMap(res -> Mono.empty());
    }

    @Override
    public void detachUserProvidedFunctionAppFromStaticSiteBuild(String resourceGroupName, String name, String environmentName, String functionAppName) {
        this.detachUserProvidedFunctionAppFromStaticSiteBuildAsync(resourceGroupName, name, environmentName, functionAppName).block();
    }

    @Override
    public Response<Void> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponse(String resourceGroupName, String name, String environmentName, String functionAppName, Context context) {
        return (Response)this.detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, functionAppName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        }
        staticSiteZipDeploymentEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createZipDeploymentForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteZipDeploymentEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuildWithResponseAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        }
        staticSiteZipDeploymentEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createZipDeploymentForStaticSiteBuild(this.client.getEndpoint(), resourceGroupName, name, environmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteZipDeploymentEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createZipDeploymentForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createZipDeploymentForStaticSiteBuildWithResponseAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, context).getSyncPoller();
    }

    @Override
    public Mono<Void> createZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> createZipDeploymentForStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return this.beginCreateZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void createZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        this.createZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope).block();
    }

    @Override
    public void createZipDeploymentForStaticSiteBuild(String resourceGroupName, String name, String environmentName, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        this.createZipDeploymentForStaticSiteBuildAsync(resourceGroupName, name, environmentName, staticSiteZipDeploymentEnvelope, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteAppSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteAppSettingsAsync(resourceGroupName, name, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsWithResponse(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, appSettings, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return this.createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner createOrUpdateStaticSiteFunctionAppSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.createOrUpdateStaticSiteFunctionAppSettingsAsync(resourceGroupName, name, appSettings).block());
    }

    @Override
    public Response<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsWithResponse(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return (Response)this.createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, appSettings, context).block();
    }

    @Override
    public Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        }
        staticSiteUserRolesInvitationEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserRolesInvitationEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserRolesInvitationEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserRolesInvitationEnvelope is required and cannot be null."));
        }
        staticSiteUserRolesInvitationEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createUserRolesInvitationLink(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserRolesInvitationEnvelope, "application/json", context);
    }

    @Override
    public Mono<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkAsync(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return this.createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserInvitationResponseResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserInvitationResponseResourceInner createUserRolesInvitationLink(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope) {
        return (StaticSiteUserInvitationResponseResourceInner)((Object)this.createUserRolesInvitationLinkAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope).block());
    }

    @Override
    public Response<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkWithResponse(String resourceGroupName, String name, StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope, Context context) {
        return (Response)this.createUserRolesInvitationLinkWithResponseAsync(resourceGroupName, name, staticSiteUserRolesInvitationEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteCustomDomains(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomainsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name), nextLink -> this.listStaticSiteCustomDomainsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomainsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listStaticSiteCustomDomainsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listStaticSiteCustomDomainsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(String resourceGroupName, String name) {
        return new PagedIterable(this.listStaticSiteCustomDomainsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listStaticSiteCustomDomainsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        return this.getStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteCustomDomainOverviewArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteCustomDomainOverviewArmResourceInner getStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        return (StaticSiteCustomDomainOverviewArmResourceInner)((Object)this.getStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).block());
    }

    @Override
    public Response<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainWithResponse(String resourceGroupName, String name, String domainName, Context context) {
        return (Response)this.getStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        }
        staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteCustomDomainRequestPropertiesEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        }
        staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteCustomDomainRequestPropertiesEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner> beginCreateOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteCustomDomainOverviewArmResourceInner.class), (Type)((Object)StaticSiteCustomDomainOverviewArmResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner> beginCreateOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteCustomDomainOverviewArmResourceInner.class), (Type)((Object)StaticSiteCustomDomainOverviewArmResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner> beginCreateOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner> beginCreateOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).getSyncPoller();
    }

    @Override
    public Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        return this.beginCreateOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return (StaticSiteCustomDomainOverviewArmResourceInner)((Object)this.createOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).block());
    }

    @Override
    public StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        return (StaticSiteCustomDomainOverviewArmResourceInner)((Object)this.createOrUpdateStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomainWithResponseAsync(String resourceGroupName, String name, String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteStaticSiteCustomDomain(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteStaticSiteCustomDomainWithResponseAsync(resourceGroupName, name, domainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, Context context) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName, Context context) {
        return this.beginDeleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName) {
        this.deleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName).block();
    }

    @Override
    public void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, Context context) {
        this.deleteStaticSiteCustomDomainAsync(resourceGroupName, name, domainName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        }
        staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteCustomDomainRequestPropertiesEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteCustomDomainRequestPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteCustomDomainRequestPropertiesEnvelope is required and cannot be null."));
        }
        staticSiteCustomDomainRequestPropertiesEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateCustomDomainCanBeAddedToStaticSite(this.client.getEndpoint(), resourceGroupName, name, domainName, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteCustomDomainRequestPropertiesEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).getSyncPoller();
    }

    @Override
    public Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        return this.beginValidateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void validateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope) {
        this.validateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope).block();
    }

    @Override
    public void validateCustomDomainCanBeAddedToStaticSite(String resourceGroupName, String name, String domainName, StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope, Context context) {
        this.validateCustomDomainCanBeAddedToStaticSiteAsync(resourceGroupName, name, domainName, staticSiteCustomDomainRequestPropertiesEnvelope, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.detachStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDetachStaticSiteAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.detachStaticSiteWithResponseAsync(resourceGroupName, name);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDetachStaticSiteAsync(String resourceGroupName, String name, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.detachStaticSiteWithResponseAsync(resourceGroupName, name, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name, Context context) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name, context).getSyncPoller();
    }

    @Override
    public Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name, Context context) {
        return this.beginDetachStaticSiteAsync(resourceGroupName, name, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void detachStaticSite(String resourceGroupName, String name) {
        this.detachStaticSiteAsync(resourceGroupName, name).block();
    }

    @Override
    public void detachStaticSite(String resourceGroupName, String name, Context context) {
        this.detachStaticSiteAsync(resourceGroupName, name, context).block();
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name), nextLink -> this.listStaticSiteFunctionsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listStaticSiteFunctionsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listStaticSiteFunctionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName, String name) {
        return new PagedIterable(this.listStaticSiteFunctionsAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listStaticSiteFunctionsAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteAppSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteAppSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteAppSettingsAsync(String resourceGroupName, String name) {
        return this.listStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteAppSettings(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listStaticSiteAppSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteAppSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteAppSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StringListInner>> listStaticSiteConfiguredRolesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteConfiguredRoles(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringListInner>> listStaticSiteConfiguredRolesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteConfiguredRoles(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringListInner> listStaticSiteConfiguredRolesAsync(String resourceGroupName, String name) {
        return this.listStaticSiteConfiguredRolesWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringListInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringListInner listStaticSiteConfiguredRoles(String resourceGroupName, String name) {
        return (StringListInner)((Object)this.listStaticSiteConfiguredRolesAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringListInner> listStaticSiteConfiguredRolesWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteConfiguredRolesWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctionAppSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name) {
        return this.listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteFunctionAppSettings(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listStaticSiteFunctionAppSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteFunctionAppSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteFunctionAppSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StringDictionaryInner> listStaticSiteSecretsAsync(String resourceGroupName, String name) {
        return this.listStaticSiteSecretsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StringDictionaryInner listStaticSiteSecrets(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listStaticSiteSecretsAsync(resourceGroupName, name).block());
    }

    @Override
    public Response<StringDictionaryInner> listStaticSiteSecretsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listStaticSiteSecretsWithResponseAsync(resourceGroupName, name, context).block();
    }

    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateEndpointConnectionList(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateEndpointConnectionList(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name), nextLink -> this.getPrivateEndpointConnectionListNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getPrivateEndpointConnectionListNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(String resourceGroupName, String name) {
        return new PagedIterable(this.getPrivateEndpointConnectionListAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getPrivateEndpointConnectionListAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RemotePrivateEndpointConnectionArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public RemotePrivateEndpointConnectionArmResourceInner getPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.getPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).block());
    }

    @Override
    public Response<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionWithResponse(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return (Response)this.getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        }
        privateEndpointWrapper.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), privateEndpointWrapper, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        }
        privateEndpointWrapper.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), privateEndpointWrapper, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveOrRejectPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveOrRejectPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).getSyncPoller();
    }

    @Override
    public Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).block());
    }

    @Override
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), Context.NONE);
    }

    private PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), context);
    }

    @Override
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).getSyncPoller();
    }

    @Override
    public Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).block();
    }

    @Override
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).block();
    }

    @Override
    public Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesAsync(String resourceGroupName, String name) {
        return this.getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PrivateLinkResourcesWrapperInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public PrivateLinkResourcesWrapperInner getPrivateLinkResources(String resourceGroupName, String name) {
        return (PrivateLinkResourcesWrapperInner)this.getPrivateLinkResourcesAsync(resourceGroupName, name).block();
    }

    @Override
    public Response<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    public Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        }
        resetPropertiesEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resetPropertiesEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resetPropertiesEnvelope is required and cannot be null."));
        }
        resetPropertiesEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetStaticSiteApiKey(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), resetPropertiesEnvelope, "application/json", context);
    }

    @Override
    public Mono<Void> resetStaticSiteApiKeyAsync(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        return this.resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope).flatMap(res -> Mono.empty());
    }

    @Override
    public void resetStaticSiteApiKey(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope) {
        this.resetStaticSiteApiKeyAsync(resourceGroupName, name, resetPropertiesEnvelope).block();
    }

    @Override
    public Response<Void> resetStaticSiteApiKeyWithResponse(String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope, Context context) {
        return (Response)this.resetStaticSiteApiKeyWithResponseAsync(resourceGroupName, name, resetPropertiesEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppsForStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppsForStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(resourceGroupName, name), nextLink -> this.getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getUserProvidedFunctionAppsForStaticSiteSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSite(String resourceGroupName, String name) {
        return new PagedIterable(this.getUserProvidedFunctionAppsForStaticSiteAsync(resourceGroupName, name));
    }

    @Override
    public PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSite(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getUserProvidedFunctionAppsForStaticSiteAsync(resourceGroupName, name, context));
    }

    @Override
    public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppForStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppForStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteAsync(String resourceGroupName, String name, String functionAppName) {
        return this.getUserProvidedFunctionAppForStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner getUserProvidedFunctionAppForStaticSite(String resourceGroupName, String name, String functionAppName) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.getUserProvidedFunctionAppForStaticSiteAsync(resourceGroupName, name, functionAppName).block());
    }

    @Override
    public Response<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteWithResponse(String resourceGroupName, String name, String functionAppName, Context context) {
        return (Response)this.getUserProvidedFunctionAppForStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        }
        staticSiteUserProvidedFunctionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.registerUserProvidedFunctionAppWithStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, isForced, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteUserProvidedFunctionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteUserProvidedFunctionEnvelope is required and cannot be null."));
        }
        staticSiteUserProvidedFunctionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.registerUserProvidedFunctionAppWithStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, isForced, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteUserProvidedFunctionEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), (Type)((Object)StaticSiteUserProvidedFunctionAppArmResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>, StaticSiteUserProvidedFunctionAppArmResourceInner> beginRegisterUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).getSyncPoller();
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        Boolean isForced = null;
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return this.beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).block());
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope) {
        Boolean isForced = null;
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced).block());
    }

    @Override
    public StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(String resourceGroupName, String name, String functionAppName, StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope, Boolean isForced, Context context) {
        return (StaticSiteUserProvidedFunctionAppArmResourceInner)((Object)this.registerUserProvidedFunctionAppWithStaticSiteAsync(resourceGroupName, name, functionAppName, staticSiteUserProvidedFunctionEnvelope, isForced, context).block());
    }

    @Override
    public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.detachUserProvidedFunctionAppFromStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(String resourceGroupName, String name, String functionAppName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionAppName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionAppName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.detachUserProvidedFunctionAppFromStaticSite(this.client.getEndpoint(), resourceGroupName, name, functionAppName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<Void> detachUserProvidedFunctionAppFromStaticSiteAsync(String resourceGroupName, String name, String functionAppName) {
        return this.detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName).flatMap(res -> Mono.empty());
    }

    @Override
    public void detachUserProvidedFunctionAppFromStaticSite(String resourceGroupName, String name, String functionAppName) {
        this.detachUserProvidedFunctionAppFromStaticSiteAsync(resourceGroupName, name, functionAppName).block();
    }

    @Override
    public Response<Void> detachUserProvidedFunctionAppFromStaticSiteWithResponse(String resourceGroupName, String name, String functionAppName, Context context) {
        return (Response)this.detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(resourceGroupName, name, functionAppName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        }
        staticSiteZipDeploymentEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createZipDeploymentForStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteZipDeploymentEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteWithResponseAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (staticSiteZipDeploymentEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter staticSiteZipDeploymentEnvelope is required and cannot be null."));
        }
        staticSiteZipDeploymentEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createZipDeploymentForStaticSite(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), staticSiteZipDeploymentEnvelope, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createZipDeploymentForStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createZipDeploymentForStaticSiteWithResponseAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope, context).getSyncPoller();
    }

    @Override
    public Mono<Void> createZipDeploymentForStaticSiteAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> createZipDeploymentForStaticSiteAsync(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        return this.beginCreateZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void createZipDeploymentForStaticSite(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope) {
        this.createZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope).block();
    }

    @Override
    public void createZipDeploymentForStaticSite(String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope, Context context) {
        this.createZipDeploymentForStaticSiteAsync(resourceGroupName, name, staticSiteZipDeploymentEnvelope, context).block();
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStaticSitesByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteArmResourceInner>> getStaticSitesByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStaticSitesByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCollection)res.getValue()).value(), ((StaticSiteCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteUsersNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserArmResourceInner>> listStaticSiteUsersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteUsersNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserCollection)res.getValue()).value(), ((StaticSiteUserCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStaticSiteBuildsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteBuildArmResourceInner>> getStaticSiteBuildsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStaticSiteBuildsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteBuildCollection)res.getValue()).value(), ((StaticSiteBuildCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteBuildFunctionsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteBuildFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteBuildFunctionsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppsForStaticSiteBuildNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteBuildNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppsForStaticSiteBuildNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteCustomDomainsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteCustomDomainOverviewArmResourceInner>> listStaticSiteCustomDomainsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteCustomDomainsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).value(), ((StaticSiteCustomDomainOverviewCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listStaticSiteFunctionsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteFunctionOverviewArmResourceInner>> listStaticSiteFunctionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listStaticSiteFunctionsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteFunctionOverviewCollection)res.getValue()).value(), ((StaticSiteFunctionOverviewCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateEndpointConnectionListNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateEndpointConnectionListNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUserProvidedFunctionAppsForStaticSiteNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppsForStaticSiteNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUserProvidedFunctionAppsForStaticSiteNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).value(), ((StaticSiteUserProvidedFunctionAppsCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface StaticSitesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/previewStaticSiteWorkflowFile")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflow(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") StaticSitesWorkflowPreviewRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteArmResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteArmResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteArmResourceInner>> updateStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSitePatchResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserCollection>> listStaticSiteUsers(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteStaticSiteUser(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="userid") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUser(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="authprovider") String var4, @PathParam(value="userid") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") StaticSiteUserArmResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuilds(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/appsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StringDictionaryInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/config/functionappsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StringDictionaryInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/functions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listAppSettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/listFunctionAppSettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="functionAppName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="functionAppName") String var5, @QueryParam(value="isForced") Boolean var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") StaticSiteUserProvidedFunctionAppArmResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="functionAppName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/zipdeploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuild(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="environmentName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StaticSiteZipDeploymentArmResource var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/appsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StringDictionaryInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StringDictionaryInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLink(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteUserInvitationRequestResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomains(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StaticSiteCustomDomainRequestPropertiesArmResource var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="domainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") StaticSiteCustomDomainRequestPropertiesArmResource var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> detachStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listAppSettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listConfiguredRoles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringListInner>> listStaticSiteConfiguredRoles(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettings(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StringDictionaryInner>> listStaticSiteSecrets(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionList(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnection(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnection(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") PrivateLinkConnectionApprovalRequestResource var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateEndpointConnections/{privateEndpointConnectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnection(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="privateEndpointConnectionName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResources(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resetStaticSiteApiKey(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteResetPropertiesArmResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>> getUserProvidedFunctionAppForStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="functionAppName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="functionAppName") String var4, @QueryParam(value="isForced") Boolean var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") StaticSiteUserProvidedFunctionAppArmResourceInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/userProvidedFunctionApps/{functionAppName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="functionAppName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/zipdeploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSite(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") StaticSiteZipDeploymentArmResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCollection>> getStaticSitesByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserCollection>> listStaticSiteUsersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteBuildCollection>> getStaticSiteBuildsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteBuildFunctionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteBuildNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteCustomDomainOverviewCollection>> listStaticSiteCustomDomainsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteFunctionOverviewCollection>> listStaticSiteFunctionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<PrivateEndpointConnectionCollection>> getPrivateEndpointConnectionListNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<StaticSiteUserProvidedFunctionAppsCollection>> getUserProvidedFunctionAppsForStaticSiteNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

