/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.AppServiceCertificateOrdersClient;
import com.azure.resourcemanager.appservice.fluent.AppServiceEnvironmentsClient;
import com.azure.resourcemanager.appservice.fluent.AppServicePlansClient;
import com.azure.resourcemanager.appservice.fluent.CertificateOrdersDiagnosticsClient;
import com.azure.resourcemanager.appservice.fluent.CertificateRegistrationProvidersClient;
import com.azure.resourcemanager.appservice.fluent.CertificatesClient;
import com.azure.resourcemanager.appservice.fluent.DeletedWebAppsClient;
import com.azure.resourcemanager.appservice.fluent.DiagnosticsClient;
import com.azure.resourcemanager.appservice.fluent.DomainRegistrationProvidersClient;
import com.azure.resourcemanager.appservice.fluent.DomainsClient;
import com.azure.resourcemanager.appservice.fluent.GlobalsClient;
import com.azure.resourcemanager.appservice.fluent.ProvidersClient;
import com.azure.resourcemanager.appservice.fluent.RecommendationsClient;
import com.azure.resourcemanager.appservice.fluent.ResourceHealthMetadatasClient;
import com.azure.resourcemanager.appservice.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.appservice.fluent.StaticSitesClient;
import com.azure.resourcemanager.appservice.fluent.TopLevelDomainsClient;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.implementation.AppServiceCertificateOrdersClientImpl;
import com.azure.resourcemanager.appservice.implementation.AppServiceEnvironmentsClientImpl;
import com.azure.resourcemanager.appservice.implementation.AppServicePlansClientImpl;
import com.azure.resourcemanager.appservice.implementation.CertificateOrdersDiagnosticsClientImpl;
import com.azure.resourcemanager.appservice.implementation.CertificateRegistrationProvidersClientImpl;
import com.azure.resourcemanager.appservice.implementation.CertificatesClientImpl;
import com.azure.resourcemanager.appservice.implementation.DeletedWebAppsClientImpl;
import com.azure.resourcemanager.appservice.implementation.DiagnosticsClientImpl;
import com.azure.resourcemanager.appservice.implementation.DomainRegistrationProvidersClientImpl;
import com.azure.resourcemanager.appservice.implementation.DomainsClientImpl;
import com.azure.resourcemanager.appservice.implementation.GlobalsClientImpl;
import com.azure.resourcemanager.appservice.implementation.ProvidersClientImpl;
import com.azure.resourcemanager.appservice.implementation.RecommendationsClientImpl;
import com.azure.resourcemanager.appservice.implementation.ResourceHealthMetadatasClientImpl;
import com.azure.resourcemanager.appservice.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.appservice.implementation.StaticSitesClientImpl;
import com.azure.resourcemanager.appservice.implementation.TopLevelDomainsClientImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class WebSiteManagementClientImpl
extends AzureServiceClient
implements WebSiteManagementClient {
    private final ClientLogger logger = new ClientLogger(WebSiteManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AppServiceCertificateOrdersClient appServiceCertificateOrders;
    private final CertificateOrdersDiagnosticsClient certificateOrdersDiagnostics;
    private final CertificateRegistrationProvidersClient certificateRegistrationProviders;
    private final DomainsClient domains;
    private final TopLevelDomainsClient topLevelDomains;
    private final DomainRegistrationProvidersClient domainRegistrationProviders;
    private final CertificatesClient certificates;
    private final DeletedWebAppsClient deletedWebApps;
    private final DiagnosticsClient diagnostics;
    private final GlobalsClient globals;
    private final ProvidersClient providers;
    private final RecommendationsClient recommendations;
    private final ResourceProvidersClient resourceProviders;
    private final WebAppsClient webApps;
    private final StaticSitesClient staticSites;
    private final AppServiceEnvironmentsClient appServiceEnvironments;
    private final AppServicePlansClient appServicePlans;
    private final ResourceHealthMetadatasClient resourceHealthMetadatas;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AppServiceCertificateOrdersClient getAppServiceCertificateOrders() {
        return this.appServiceCertificateOrders;
    }

    @Override
    public CertificateOrdersDiagnosticsClient getCertificateOrdersDiagnostics() {
        return this.certificateOrdersDiagnostics;
    }

    @Override
    public CertificateRegistrationProvidersClient getCertificateRegistrationProviders() {
        return this.certificateRegistrationProviders;
    }

    @Override
    public DomainsClient getDomains() {
        return this.domains;
    }

    @Override
    public TopLevelDomainsClient getTopLevelDomains() {
        return this.topLevelDomains;
    }

    @Override
    public DomainRegistrationProvidersClient getDomainRegistrationProviders() {
        return this.domainRegistrationProviders;
    }

    @Override
    public CertificatesClient getCertificates() {
        return this.certificates;
    }

    @Override
    public DeletedWebAppsClient getDeletedWebApps() {
        return this.deletedWebApps;
    }

    @Override
    public DiagnosticsClient getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public GlobalsClient getGlobals() {
        return this.globals;
    }

    @Override
    public ProvidersClient getProviders() {
        return this.providers;
    }

    @Override
    public RecommendationsClient getRecommendations() {
        return this.recommendations;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public WebAppsClient getWebApps() {
        return this.webApps;
    }

    @Override
    public StaticSitesClient getStaticSites() {
        return this.staticSites;
    }

    @Override
    public AppServiceEnvironmentsClient getAppServiceEnvironments() {
        return this.appServiceEnvironments;
    }

    @Override
    public AppServicePlansClient getAppServicePlans() {
        return this.appServicePlans;
    }

    @Override
    public ResourceHealthMetadatasClient getResourceHealthMetadatas() {
        return this.resourceHealthMetadatas;
    }

    WebSiteManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2020-12-01";
        this.appServiceCertificateOrders = new AppServiceCertificateOrdersClientImpl(this);
        this.certificateOrdersDiagnostics = new CertificateOrdersDiagnosticsClientImpl(this);
        this.certificateRegistrationProviders = new CertificateRegistrationProvidersClientImpl(this);
        this.domains = new DomainsClientImpl(this);
        this.topLevelDomains = new TopLevelDomainsClientImpl(this);
        this.domainRegistrationProviders = new DomainRegistrationProvidersClientImpl(this);
        this.certificates = new CertificatesClientImpl(this);
        this.deletedWebApps = new DeletedWebAppsClientImpl(this);
        this.diagnostics = new DiagnosticsClientImpl(this);
        this.globals = new GlobalsClientImpl(this);
        this.providers = new ProvidersClientImpl(this);
        this.recommendations = new RecommendationsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.webApps = new WebAppsClientImpl(this);
        this.staticSites = new StaticSitesClientImpl(this);
        this.appServiceEnvironments = new AppServiceEnvironmentsClientImpl(this);
        this.appServicePlans = new AppServicePlansClientImpl(this);
        this.resourceHealthMetadatas = new ResourceHealthMetadatasClientImpl(this);
    }
}

