/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.JwtClaimChecks;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class AzureActiveDirectoryValidation
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureActiveDirectoryValidation.class);
    @JsonProperty(value="properties.jwtClaimChecks")
    private JwtClaimChecks jwtClaimChecks;
    @JsonProperty(value="properties.allowedAudiences")
    private List<String> allowedAudiences;

    public JwtClaimChecks jwtClaimChecks() {
        return this.jwtClaimChecks;
    }

    public AzureActiveDirectoryValidation withJwtClaimChecks(JwtClaimChecks jwtClaimChecks) {
        this.jwtClaimChecks = jwtClaimChecks;
        return this;
    }

    public List<String> allowedAudiences() {
        return this.allowedAudiences;
    }

    public AzureActiveDirectoryValidation withAllowedAudiences(List<String> allowedAudiences) {
        this.allowedAudiences = allowedAudiences;
        return this;
    }

    @Override
    public AzureActiveDirectoryValidation withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.jwtClaimChecks() != null) {
            this.jwtClaimChecks().validate();
        }
    }
}

