/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.OpenIdConnectClientCredential;
import com.azure.resourcemanager.appservice.models.OpenIdConnectConfig;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class OpenIdConnectRegistration
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OpenIdConnectRegistration.class);
    @JsonProperty(value="properties.clientId")
    private String clientId;
    @JsonProperty(value="properties.clientCredential")
    private OpenIdConnectClientCredential clientCredential;
    @JsonProperty(value="properties.openIdConnectConfiguration")
    private OpenIdConnectConfig openIdConnectConfiguration;

    public String clientId() {
        return this.clientId;
    }

    public OpenIdConnectRegistration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OpenIdConnectClientCredential clientCredential() {
        return this.clientCredential;
    }

    public OpenIdConnectRegistration withClientCredential(OpenIdConnectClientCredential clientCredential) {
        this.clientCredential = clientCredential;
        return this;
    }

    public OpenIdConnectConfig openIdConnectConfiguration() {
        return this.openIdConnectConfiguration;
    }

    public OpenIdConnectRegistration withOpenIdConnectConfiguration(OpenIdConnectConfig openIdConnectConfiguration) {
        this.openIdConnectConfiguration = openIdConnectConfiguration;
        return this;
    }

    @Override
    public OpenIdConnectRegistration withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.clientCredential() != null) {
            this.clientCredential().validate();
        }
        if (this.openIdConnectConfiguration() != null) {
            this.openIdConnectConfiguration().validate();
        }
    }
}

