/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class StaticSitePatchResource
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSitePatchResource.class);
    @JsonProperty(value="properties.defaultHostname", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;
    @JsonProperty(value="properties.repositoryUrl")
    private String repositoryUrl;
    @JsonProperty(value="properties.branch")
    private String branch;
    @JsonProperty(value="properties.provider", access=JsonProperty.Access.WRITE_ONLY)
    private String provider;
    @JsonProperty(value="properties.customDomains", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> customDomains;
    @JsonProperty(value="properties.repositoryToken")
    private String repositoryToken;
    @JsonProperty(value="properties.buildProperties")
    private StaticSiteBuildProperties buildProperties;
    @JsonProperty(value="properties.templateProperties")
    private StaticSiteTemplateOptions templateProperties;
    @JsonProperty(value="properties.privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;
    @JsonProperty(value="properties.contentDistributionEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String contentDistributionEndpoint;
    @JsonProperty(value="properties.keyVaultReferenceIdentity", access=JsonProperty.Access.WRITE_ONLY)
    private String keyVaultReferenceIdentity;
    @JsonProperty(value="properties.userProvidedFunctionApps", access=JsonProperty.Access.WRITE_ONLY)
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;
    @JsonProperty(value="properties.stagingEnvironmentPolicy")
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;
    @JsonProperty(value="properties.allowConfigFileUpdates")
    private Boolean allowConfigFileUpdates;

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSitePatchResource withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSitePatchResource withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String provider() {
        return this.provider;
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String repositoryToken() {
        return this.repositoryToken;
    }

    public StaticSitePatchResource withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSitePatchResource withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    public StaticSitePatchResource withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    public StaticSitePatchResource withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    public StaticSitePatchResource withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    @Override
    public StaticSitePatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
        if (this.templateProperties() != null) {
            this.templateProperties().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.userProvidedFunctionApps() != null) {
            this.userProvidedFunctionApps().forEach(e -> e.validate());
        }
    }
}

