/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.BlobStorageTokenStore;
import com.azure.resourcemanager.appservice.models.FileSystemTokenStore;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class TokenStore
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TokenStore.class);
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.tokenRefreshExtensionHours")
    private Double tokenRefreshExtensionHours;
    @JsonProperty(value="properties.fileSystem")
    private FileSystemTokenStore fileSystem;
    @JsonProperty(value="properties.azureBlobStorage")
    private BlobStorageTokenStore azureBlobStorage;

    public Boolean enabled() {
        return this.enabled;
    }

    public TokenStore withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Double tokenRefreshExtensionHours() {
        return this.tokenRefreshExtensionHours;
    }

    public TokenStore withTokenRefreshExtensionHours(Double tokenRefreshExtensionHours) {
        this.tokenRefreshExtensionHours = tokenRefreshExtensionHours;
        return this;
    }

    public FileSystemTokenStore fileSystem() {
        return this.fileSystem;
    }

    public TokenStore withFileSystem(FileSystemTokenStore fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public BlobStorageTokenStore azureBlobStorage() {
        return this.azureBlobStorage;
    }

    public TokenStore withAzureBlobStorage(BlobStorageTokenStore azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
        return this;
    }

    @Override
    public TokenStore withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.fileSystem() != null) {
            this.fileSystem().validate();
        }
        if (this.azureBlobStorage() != null) {
            this.azureBlobStorage().validate();
        }
    }
}

