// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AuthType;
import com.azure.resourcemanager.appservice.models.EnvironmentVariable;
import com.azure.resourcemanager.appservice.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.time.OffsetDateTime;
import java.util.List;

/**
 * SiteContainer resource specific properties.
 */
@Fluent
public final class SiteContainerProperties {
    /*
     * Image Name
     */
    @JsonProperty(value = "image", required = true)
    private String image;

    /*
     * Target Port
     */
    @JsonProperty(value = "targetPort")
    private String targetPort;

    /*
     * <code>true</code> if the container is the main site container; <code>false</code> otherwise.
     */
    @JsonProperty(value = "isMain", required = true)
    private boolean isMain;

    /*
     * StartUp Command
     */
    @JsonProperty(value = "startUpCommand")
    private String startUpCommand;

    /*
     * Auth Type
     */
    @JsonProperty(value = "authType")
    private AuthType authType;

    /*
     * User Name
     */
    @JsonProperty(value = "userName")
    private String username;

    /*
     * Password Secret
     */
    @JsonProperty(value = "passwordSecret")
    private String passwordSecret;

    /*
     * UserManagedIdentity ClientId
     */
    @JsonProperty(value = "userManagedIdentityClientId")
    private String userManagedIdentityClientId;

    /*
     * Created Time
     */
    @JsonProperty(value = "createdTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;

    /*
     * Last Modified Time
     */
    @JsonProperty(value = "lastModifiedTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;

    /*
     * List of volume mounts
     */
    @JsonProperty(value = "volumeMounts")
    private List<VolumeMount> volumeMounts;

    /*
     * List of environment variables
     */
    @JsonProperty(value = "environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Creates an instance of SiteContainerProperties class.
     */
    public SiteContainerProperties() {
    }

    /**
     * Get the image property: Image Name.
     *
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: Image Name.
     *
     * @param image the image value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Get the targetPort property: Target Port.
     *
     * @return the targetPort value.
     */
    public String targetPort() {
        return this.targetPort;
    }

    /**
     * Set the targetPort property: Target Port.
     *
     * @param targetPort the targetPort value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withTargetPort(String targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    /**
     * Get the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     *
     * @return the isMain value.
     */
    public boolean isMain() {
        return this.isMain;
    }

    /**
     * Set the isMain property: &lt;code&gt;true&lt;/code&gt; if the container is the main site container;
     * &lt;code&gt;false&lt;/code&gt; otherwise.
     *
     * @param isMain the isMain value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withIsMain(boolean isMain) {
        this.isMain = isMain;
        return this;
    }

    /**
     * Get the startUpCommand property: StartUp Command.
     *
     * @return the startUpCommand value.
     */
    public String startUpCommand() {
        return this.startUpCommand;
    }

    /**
     * Set the startUpCommand property: StartUp Command.
     *
     * @param startUpCommand the startUpCommand value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withStartUpCommand(String startUpCommand) {
        this.startUpCommand = startUpCommand;
        return this;
    }

    /**
     * Get the authType property: Auth Type.
     *
     * @return the authType value.
     */
    public AuthType authType() {
        return this.authType;
    }

    /**
     * Set the authType property: Auth Type.
     *
     * @param authType the authType value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    /**
     * Get the username property: User Name.
     *
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: User Name.
     *
     * @param username the username value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the passwordSecret property: Password Secret.
     *
     * @return the passwordSecret value.
     */
    public String passwordSecret() {
        return this.passwordSecret;
    }

    /**
     * Set the passwordSecret property: Password Secret.
     *
     * @param passwordSecret the passwordSecret value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withPasswordSecret(String passwordSecret) {
        this.passwordSecret = passwordSecret;
        return this;
    }

    /**
     * Get the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     *
     * @return the userManagedIdentityClientId value.
     */
    public String userManagedIdentityClientId() {
        return this.userManagedIdentityClientId;
    }

    /**
     * Set the userManagedIdentityClientId property: UserManagedIdentity ClientId.
     *
     * @param userManagedIdentityClientId the userManagedIdentityClientId value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withUserManagedIdentityClientId(String userManagedIdentityClientId) {
        this.userManagedIdentityClientId = userManagedIdentityClientId;
        return this;
    }

    /**
     * Get the createdTime property: Created Time.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the lastModifiedTime property: Last Modified Time.
     *
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the volumeMounts property: List of volume mounts.
     *
     * @return the volumeMounts value.
     */
    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    /**
     * Set the volumeMounts property: List of volume mounts.
     *
     * @param volumeMounts the volumeMounts value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    /**
     * Get the environmentVariables property: List of environment variables.
     *
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: List of environment variables.
     *
     * @param environmentVariables the environmentVariables value to set.
     * @return the SiteContainerProperties object itself.
     */
    public SiteContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (image() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property image in model SiteContainerProperties"));
        }
        if (volumeMounts() != null) {
            volumeMounts().forEach(e -> e.validate());
        }
        if (environmentVariables() != null) {
            environmentVariables().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SiteContainerProperties.class);
}
