// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;

/**
 * Property to select authentication type to access the selected storage account. Available options:
 * SystemAssignedIdentity, UserAssignedIdentity, StorageAccountConnectionString.
 */
public final class AuthenticationType extends ExpandableStringEnum<AuthenticationType> {
    /**
     * Static value SystemAssignedIdentity for AuthenticationType.
     */
    public static final AuthenticationType SYSTEM_ASSIGNED_IDENTITY = fromString("SystemAssignedIdentity");

    /**
     * Static value UserAssignedIdentity for AuthenticationType.
     */
    public static final AuthenticationType USER_ASSIGNED_IDENTITY = fromString("UserAssignedIdentity");

    /**
     * Static value StorageAccountConnectionString for AuthenticationType.
     */
    public static final AuthenticationType STORAGE_ACCOUNT_CONNECTION_STRING
        = fromString("StorageAccountConnectionString");

    /**
     * Creates a new instance of AuthenticationType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AuthenticationType() {
    }

    /**
     * Creates or finds a AuthenticationType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AuthenticationType.
     */
    @JsonCreator
    public static AuthenticationType fromString(String name) {
        return fromString(name, AuthenticationType.class);
    }

    /**
     * Gets known AuthenticationType values.
     *
     * @return known AuthenticationType values.
     */
    public static Collection<AuthenticationType> values() {
        return values(AuthenticationType.class);
    }
}
