// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ContainerAppsConfiguration model.
 */
@Fluent
public final class ContainerAppsConfiguration {
    /*
     * Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    @JsonProperty(value = "daprAIInstrumentationKey")
    private String daprAIInstrumentationKey;

    /*
     * IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     */
    @JsonProperty(value = "platformReservedCidr")
    private String platformReservedCidr;

    /*
     * An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
     */
    @JsonProperty(value = "platformReservedDnsIP")
    private String platformReservedDnsIp;

    /*
     * Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JsonProperty(value = "controlPlaneSubnetResourceId")
    private String controlPlaneSubnetResourceId;

    /*
     * Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JsonProperty(value = "appSubnetResourceId")
    private String appSubnetResourceId;

    /*
     * CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     */
    @JsonProperty(value = "dockerBridgeCidr")
    private String dockerBridgeCidr;

    /**
     * Creates an instance of ContainerAppsConfiguration class.
     */
    public ContainerAppsConfiguration() {
    }

    /**
     * Get the daprAIInstrumentationKey property: Azure Monitor instrumentation key used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @return the daprAIInstrumentationKey value.
     */
    public String daprAIInstrumentationKey() {
        return this.daprAIInstrumentationKey;
    }

    /**
     * Set the daprAIInstrumentationKey property: Azure Monitor instrumentation key used by Dapr to export Service to
     * Service communication telemetry.
     * 
     * @param daprAIInstrumentationKey the daprAIInstrumentationKey value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withDaprAIInstrumentationKey(String daprAIInstrumentationKey) {
        this.daprAIInstrumentationKey = daprAIInstrumentationKey;
        return this;
    }

    /**
     * Get the platformReservedCidr property: IP range in CIDR notation that can be reserved for environment
     * infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     * 
     * @return the platformReservedCidr value.
     */
    public String platformReservedCidr() {
        return this.platformReservedCidr;
    }

    /**
     * Set the platformReservedCidr property: IP range in CIDR notation that can be reserved for environment
     * infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     * 
     * @param platformReservedCidr the platformReservedCidr value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withPlatformReservedCidr(String platformReservedCidr) {
        this.platformReservedCidr = platformReservedCidr;
        return this;
    }

    /**
     * Get the platformReservedDnsIp property: An IP address from the IP range defined by platformReservedCidr that will
     * be reserved for the internal DNS server.
     * 
     * @return the platformReservedDnsIp value.
     */
    public String platformReservedDnsIp() {
        return this.platformReservedDnsIp;
    }

    /**
     * Set the platformReservedDnsIp property: An IP address from the IP range defined by platformReservedCidr that will
     * be reserved for the internal DNS server.
     * 
     * @param platformReservedDnsIp the platformReservedDnsIp value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withPlatformReservedDnsIp(String platformReservedDnsIp) {
        this.platformReservedDnsIp = platformReservedDnsIp;
        return this;
    }

    /**
     * Get the controlPlaneSubnetResourceId property: Resource ID of a subnet for control plane infrastructure
     * components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap
     * with the IP range defined in platformReservedCidr, if defined.
     * 
     * @return the controlPlaneSubnetResourceId value.
     */
    public String controlPlaneSubnetResourceId() {
        return this.controlPlaneSubnetResourceId;
    }

    /**
     * Set the controlPlaneSubnetResourceId property: Resource ID of a subnet for control plane infrastructure
     * components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap
     * with the IP range defined in platformReservedCidr, if defined.
     * 
     * @param controlPlaneSubnetResourceId the controlPlaneSubnetResourceId value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withControlPlaneSubnetResourceId(String controlPlaneSubnetResourceId) {
        this.controlPlaneSubnetResourceId = controlPlaneSubnetResourceId;
        return this;
    }

    /**
     * Get the appSubnetResourceId property: Resource ID of a subnet for control plane infrastructure components. This
     * subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range
     * defined in platformReservedCidr, if defined.
     * 
     * @return the appSubnetResourceId value.
     */
    public String appSubnetResourceId() {
        return this.appSubnetResourceId;
    }

    /**
     * Set the appSubnetResourceId property: Resource ID of a subnet for control plane infrastructure components. This
     * subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range
     * defined in platformReservedCidr, if defined.
     * 
     * @param appSubnetResourceId the appSubnetResourceId value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withAppSubnetResourceId(String appSubnetResourceId) {
        this.appSubnetResourceId = appSubnetResourceId;
        return this;
    }

    /**
     * Get the dockerBridgeCidr property: CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     * 
     * @return the dockerBridgeCidr value.
     */
    public String dockerBridgeCidr() {
        return this.dockerBridgeCidr;
    }

    /**
     * Set the dockerBridgeCidr property: CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     * 
     * @param dockerBridgeCidr the dockerBridgeCidr value to set.
     * @return the ContainerAppsConfiguration object itself.
     */
    public ContainerAppsConfiguration withDockerBridgeCidr(String dockerBridgeCidr) {
        this.dockerBridgeCidr = dockerBridgeCidr;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
