// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.azure.resourcemanager.appservice.models.ContainerAppsConfiguration;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import java.io.IOException;

/**
 * KubeEnvironment resource specific properties.
 */
@Fluent
public final class KubeEnvironmentProperties implements JsonSerializable<KubeEnvironmentProperties> {
    /*
     * Provisioning state of the Kubernetes Environment.
     */
    private KubeEnvironmentProvisioningState provisioningState;

    /*
     * Any errors that occurred during deployment or deployment validation
     */
    private String deploymentErrors;

    /*
     * Only visible within Vnet/Subnet
     */
    private Boolean internalLoadBalancerEnabled;

    /*
     * Default Domain Name for the cluster
     */
    private String defaultDomain;

    /*
     * Static IP of the KubeEnvironment
     */
    private String staticIp;

    /*
     * Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
     */
    private String environmentType;

    /*
     * Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     */
    private ArcConfiguration arcConfiguration;

    /*
     * Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    private AppLogsConfiguration appLogsConfiguration;

    /*
     * Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET
     * Configuration
     */
    private ContainerAppsConfiguration containerAppsConfiguration;

    /*
     * The aksResourceID property.
     */
    private String aksResourceId;

    /**
     * Creates an instance of KubeEnvironmentProperties class.
     */
    public KubeEnvironmentProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the Kubernetes Environment.
     * 
     * @return the provisioningState value.
     */
    public KubeEnvironmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentErrors property: Any errors that occurred during deployment or deployment validation.
     * 
     * @return the deploymentErrors value.
     */
    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    /**
     * Get the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     * 
     * @return the internalLoadBalancerEnabled value.
     */
    public Boolean internalLoadBalancerEnabled() {
        return this.internalLoadBalancerEnabled;
    }

    /**
     * Set the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     * 
     * @param internalLoadBalancerEnabled the internalLoadBalancerEnabled value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        this.internalLoadBalancerEnabled = internalLoadBalancerEnabled;
        return this;
    }

    /**
     * Get the defaultDomain property: Default Domain Name for the cluster.
     * 
     * @return the defaultDomain value.
     */
    public String defaultDomain() {
        return this.defaultDomain;
    }

    /**
     * Get the staticIp property: Static IP of the KubeEnvironment.
     * 
     * @return the staticIp value.
     */
    public String staticIp() {
        return this.staticIp;
    }

    /**
     * Set the staticIp property: Static IP of the KubeEnvironment.
     * 
     * @param staticIp the staticIp value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    /**
     * Get the environmentType property: Type of Kubernetes Environment. Only supported for Container App Environments
     * with value as Managed.
     * 
     * @return the environmentType value.
     */
    public String environmentType() {
        return this.environmentType;
    }

    /**
     * Set the environmentType property: Type of Kubernetes Environment. Only supported for Container App Environments
     * with value as Managed.
     * 
     * @param environmentType the environmentType value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
        return this;
    }

    /**
     * Get the arcConfiguration property: Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     * 
     * @return the arcConfiguration value.
     */
    public ArcConfiguration arcConfiguration() {
        return this.arcConfiguration;
    }

    /**
     * Set the arcConfiguration property: Cluster configuration which determines the ARC cluster
     * components types. Eg: Choosing between BuildService kind,
     * FrontEnd Service ArtifactsStorageType etc.
     * 
     * @param arcConfiguration the arcConfiguration value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withArcConfiguration(ArcConfiguration arcConfiguration) {
        this.arcConfiguration = arcConfiguration;
        return this;
    }

    /**
     * Get the appLogsConfiguration property: Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported.
     * 
     * @return the appLogsConfiguration value.
     */
    public AppLogsConfiguration appLogsConfiguration() {
        return this.appLogsConfiguration;
    }

    /**
     * Set the appLogsConfiguration property: Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported.
     * 
     * @param appLogsConfiguration the appLogsConfiguration value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        this.appLogsConfiguration = appLogsConfiguration;
        return this;
    }

    /**
     * Get the containerAppsConfiguration property: Cluster configuration for Container Apps Environments to configure
     * Dapr Instrumentation Key and VNET Configuration.
     * 
     * @return the containerAppsConfiguration value.
     */
    public ContainerAppsConfiguration containerAppsConfiguration() {
        return this.containerAppsConfiguration;
    }

    /**
     * Set the containerAppsConfiguration property: Cluster configuration for Container Apps Environments to configure
     * Dapr Instrumentation Key and VNET Configuration.
     * 
     * @param containerAppsConfiguration the containerAppsConfiguration value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties
        withContainerAppsConfiguration(ContainerAppsConfiguration containerAppsConfiguration) {
        this.containerAppsConfiguration = containerAppsConfiguration;
        return this;
    }

    /**
     * Get the aksResourceId property: The aksResourceID property.
     * 
     * @return the aksResourceId value.
     */
    public String aksResourceId() {
        return this.aksResourceId;
    }

    /**
     * Set the aksResourceId property: The aksResourceID property.
     * 
     * @param aksResourceId the aksResourceId value to set.
     * @return the KubeEnvironmentProperties object itself.
     */
    public KubeEnvironmentProperties withAksResourceId(String aksResourceId) {
        this.aksResourceId = aksResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (arcConfiguration() != null) {
            arcConfiguration().validate();
        }
        if (appLogsConfiguration() != null) {
            appLogsConfiguration().validate();
        }
        if (containerAppsConfiguration() != null) {
            containerAppsConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("internalLoadBalancerEnabled", this.internalLoadBalancerEnabled);
        jsonWriter.writeStringField("staticIp", this.staticIp);
        jsonWriter.writeStringField("environmentType", this.environmentType);
        jsonWriter.writeJsonField("arcConfiguration", this.arcConfiguration);
        jsonWriter.writeJsonField("appLogsConfiguration", this.appLogsConfiguration);
        jsonWriter.writeJsonField("containerAppsConfiguration", this.containerAppsConfiguration);
        jsonWriter.writeStringField("aksResourceID", this.aksResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KubeEnvironmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KubeEnvironmentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KubeEnvironmentProperties.
     */
    public static KubeEnvironmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubeEnvironmentProperties deserializedKubeEnvironmentProperties = new KubeEnvironmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.provisioningState
                        = KubeEnvironmentProvisioningState.fromString(reader.getString());
                } else if ("deploymentErrors".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.deploymentErrors = reader.getString();
                } else if ("internalLoadBalancerEnabled".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.internalLoadBalancerEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultDomain".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.defaultDomain = reader.getString();
                } else if ("staticIp".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.staticIp = reader.getString();
                } else if ("environmentType".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.environmentType = reader.getString();
                } else if ("arcConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.arcConfiguration = ArcConfiguration.fromJson(reader);
                } else if ("appLogsConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.appLogsConfiguration = AppLogsConfiguration.fromJson(reader);
                } else if ("containerAppsConfiguration".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.containerAppsConfiguration
                        = ContainerAppsConfiguration.fromJson(reader);
                } else if ("aksResourceID".equals(fieldName)) {
                    deserializedKubeEnvironmentProperties.aksResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKubeEnvironmentProperties;
        });
    }
}
