// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Meta data about operation used for display in portal.
 */
@Fluent
public final class CsmOperationDisplay implements JsonSerializable<CsmOperationDisplay> {
    /*
     * The provider property.
     */
    private String provider;

    /*
     * The resource property.
     */
    private String resource;

    /*
     * The operation property.
     */
    private String operation;

    /*
     * The description property.
     */
    private String description;

    /**
     * Creates an instance of CsmOperationDisplay class.
     */
    public CsmOperationDisplay() {
    }

    /**
     * Get the provider property: The provider property.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: The provider property.
     * 
     * @param provider the provider value to set.
     * @return the CsmOperationDisplay object itself.
     */
    public CsmOperationDisplay withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the CsmOperationDisplay object itself.
     */
    public CsmOperationDisplay withResource(String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the operation property: The operation property.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Set the operation property: The operation property.
     * 
     * @param operation the operation value to set.
     * @return the CsmOperationDisplay object itself.
     */
    public CsmOperationDisplay withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the CsmOperationDisplay object itself.
     */
    public CsmOperationDisplay withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmOperationDisplay from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmOperationDisplay if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CsmOperationDisplay.
     */
    public static CsmOperationDisplay fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmOperationDisplay deserializedCsmOperationDisplay = new CsmOperationDisplay();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provider".equals(fieldName)) {
                    deserializedCsmOperationDisplay.provider = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedCsmOperationDisplay.resource = reader.getString();
                } else if ("operation".equals(fieldName)) {
                    deserializedCsmOperationDisplay.operation = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedCsmOperationDisplay.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmOperationDisplay;
        });
    }
}
