// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Container App container Custom scaling rule.
 */
@Fluent
public final class CustomScaleRule implements JsonSerializable<CustomScaleRule> {
    /*
     * Type of the custom scale rule
     * eg: azure-servicebus, redis etc.
     */
    private String type;

    /*
     * Metadata properties to describe custom scale rule.
     */
    private Map<String, String> metadata;

    /*
     * Authentication secrets for the custom scale rule.
     */
    private List<ScaleRuleAuth> auth;

    /**
     * Creates an instance of CustomScaleRule class.
     */
    public CustomScaleRule() {
    }

    /**
     * Get the type property: Type of the custom scale rule
     * eg: azure-servicebus, redis etc.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the custom scale rule
     * eg: azure-servicebus, redis etc.
     * 
     * @param type the type value to set.
     * @return the CustomScaleRule object itself.
     */
    public CustomScaleRule withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the metadata property: Metadata properties to describe custom scale rule.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata properties to describe custom scale rule.
     * 
     * @param metadata the metadata value to set.
     * @return the CustomScaleRule object itself.
     */
    public CustomScaleRule withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the auth property: Authentication secrets for the custom scale rule.
     * 
     * @return the auth value.
     */
    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    /**
     * Set the auth property: Authentication secrets for the custom scale rule.
     * 
     * @param auth the auth value to set.
     * @return the CustomScaleRule object itself.
     */
    public CustomScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (auth() != null) {
            auth().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomScaleRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomScaleRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomScaleRule.
     */
    public static CustomScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomScaleRule deserializedCustomScaleRule = new CustomScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedCustomScaleRule.type = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedCustomScaleRule.metadata = metadata;
                } else if ("auth".equals(fieldName)) {
                    List<ScaleRuleAuth> auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    deserializedCustomScaleRule.auth = auth;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomScaleRule;
        });
    }
}
